/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.resource;

import java.nio.file.Path;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProjectConfiguration;
import org.sonarlint.eclipse.core.resource.ISonarLintFile;
import org.sonarlint.eclipse.core.resource.ISonarLintIssuable;

public interface ISonarLintProject
extends ISonarLintIssuable {
    default public boolean isOpen() {
        return this.getResource().isAccessible();
    }

    default public boolean isBound() {
        return SonarLintProjectConfiguration.read(this.getScopeContext()).isBound();
    }

    default public boolean isAutoEnabled() {
        return SonarLintProjectConfiguration.read(this.getScopeContext()).isAutoEnabled();
    }

    default public IScopeContext getScopeContext() {
        return new ProjectScope((IProject)this.getResource());
    }

    @Override
    public String getName();

    public Path getWorkingDir();

    public boolean exists(String var1);

    public Object getObjectToNotify();

    public Collection<ISonarLintFile> files();

    default public void deleteAllMarkers(String markerId) {
        if (this.getResource().isAccessible()) {
            try {
                this.getResource().deleteMarkers(markerId, true, 2);
            }
            catch (CoreException e) {
                SonarLintLogger.get().error("Unable to delete markers on project " + this.getName(), e);
            }
        }
    }
}

