/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.tracking;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.sonarlint.eclipse.core.internal.proto.Sonarlint;
import org.sonarlint.eclipse.core.internal.tracking.StoreIndex;
import org.sonarsource.sonarlint.core.client.api.util.FileUtils;

class StringStoreIndex
implements StoreIndex<String> {
    public static final String INDEX_FILENAME = "index.pb";
    private final Path storeBasePath;
    private final Path indexFilePath;

    public StringStoreIndex(Path storeBasePath) {
        this.storeBasePath = storeBasePath;
        this.indexFilePath = storeBasePath.resolve(INDEX_FILENAME);
    }

    @Override
    public Collection<String> keys() {
        return this.load().keySet();
    }

    private Map<String, String> load() {
        if (!this.indexFilePath.toFile().exists()) {
            return Collections.emptyMap();
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream stream = Files.newInputStream(this.indexFilePath, new OpenOption[0]);){
                return Sonarlint.StorageIndex.parseFrom(stream).getMappedPathByKeyMap();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read local issue store index", e);
        }
    }

    @Override
    public void save(String storageKey, Path path) {
        String relativeMappedPath = this.storeBasePath.relativize(path).toString();
        Sonarlint.StorageIndex.Builder builder = Sonarlint.StorageIndex.newBuilder();
        builder.putAllMappedPathByKey(this.load());
        builder.putMappedPathByKey(storageKey, relativeMappedPath);
        this.save(builder.build());
    }

    @Override
    public void delete(String storageKey) {
        Sonarlint.StorageIndex.Builder builder = Sonarlint.StorageIndex.newBuilder();
        builder.putAllMappedPathByKey(this.load());
        builder.removeMappedPathByKey(storageKey);
        this.save(builder.build());
    }

    private void save(Sonarlint.StorageIndex index) {
        FileUtils.mkdirs((Path)this.indexFilePath.getParent());
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (OutputStream stream = Files.newOutputStream(this.indexFilePath, new OpenOption[0]);){
                index.writeTo(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to write local issue store index", e);
        }
    }
}

