/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.tracking;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.internal.TriggerType;
import org.sonarlint.eclipse.core.internal.jobs.AsyncServerMarkerUpdaterJob;
import org.sonarlint.eclipse.core.internal.tracking.IssueTracker;
import org.sonarlint.eclipse.core.internal.tracking.IssueTrackerRegistry;
import org.sonarlint.eclipse.core.internal.tracking.ServerIssueTrackable;
import org.sonarlint.eclipse.core.internal.tracking.Trackable;
import org.sonarlint.eclipse.core.resource.ISonarLintFile;
import org.sonarlint.eclipse.core.resource.ISonarLintIssuable;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedSonarLintEngine;
import org.sonarsource.sonarlint.core.client.api.connected.ServerConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.ServerIssue;
import org.sonarsource.sonarlint.core.client.api.exceptions.DownloadException;

public class ServerIssueUpdater {
    public static final String PATH_SEPARATOR_PATTERN = Pattern.quote(File.separator);
    private final IssueTrackerRegistry issueTrackerRegistry;

    public ServerIssueUpdater(IssueTrackerRegistry issueTrackerRegistry) {
        this.issueTrackerRegistry = issueTrackerRegistry;
    }

    public void updateAsync(ServerConfiguration serverConfiguration, ConnectedSonarLintEngine engine, ISonarLintProject project, String localModuleKey, String serverModuleKey, Collection<ISonarLintIssuable> issuables, Map<ISonarLintFile, IDocument> docPerFile, TriggerType triggerType) {
        new IssueUpdateJob(serverConfiguration, engine, project, localModuleKey, serverModuleKey, issuables, docPerFile, triggerType).schedule();
    }

    public static List<ServerIssue> fetchServerIssues(ServerConfiguration serverConfiguration, ConnectedSonarLintEngine engine, String moduleKey, ISonarLintFile resource) {
        String fileKey = resource.getProjectRelativePath();
        try {
            SonarLintLogger.get().debug("Download server issues for " + resource.getName());
            return engine.downloadServerIssues(serverConfiguration, moduleKey, fileKey);
        }
        catch (DownloadException e) {
            SonarLintLogger.get().info(e.getMessage());
            return engine.getServerIssues(moduleKey, fileKey);
        }
    }

    public static String toFileKey(IResource resource) {
        String relativePath = resource.getProjectRelativePath().toString();
        if (File.separatorChar != '/') {
            return relativePath.replaceAll(PATH_SEPARATOR_PATTERN, "/");
        }
        return relativePath;
    }

    private class IssueUpdateJob
    extends Job {
        private final ServerConfiguration serverConfiguration;
        private final ConnectedSonarLintEngine engine;
        private final String localModuleKey;
        private final String serverModuleKey;
        private final Collection<ISonarLintIssuable> issuables;
        private final ISonarLintProject project;
        private final Map<ISonarLintFile, IDocument> docPerFile;
        private final TriggerType triggerType;

        private IssueUpdateJob(ServerConfiguration serverConfiguration, ConnectedSonarLintEngine engine, ISonarLintProject project, String localModuleKey, String serverModuleKey, Collection<ISonarLintIssuable> issuables, Map<ISonarLintFile, IDocument> docPerFile, TriggerType triggerType) {
            super("Fetch server issues for " + project.getName());
            this.docPerFile = docPerFile;
            this.triggerType = triggerType;
            this.setPriority(50);
            this.serverConfiguration = serverConfiguration;
            this.engine = engine;
            this.project = project;
            this.localModuleKey = localModuleKey;
            this.serverModuleKey = serverModuleKey;
            this.issuables = issuables;
        }

        protected IStatus run(IProgressMonitor monitor) {
            HashMap<ISonarLintIssuable, Collection<Trackable>> trackedIssues = new HashMap<ISonarLintIssuable, Collection<Trackable>>();
            try {
                for (ISonarLintIssuable issuable : this.issuables) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (!(issuable instanceof ISonarLintFile)) continue;
                    String relativePath = ((ISonarLintFile)issuable).getProjectRelativePath();
                    IssueTracker issueTracker = ServerIssueUpdater.this.issueTrackerRegistry.getOrCreate(this.project, this.localModuleKey);
                    List<ServerIssue> serverIssues = ServerIssueUpdater.fetchServerIssues(this.serverConfiguration, this.engine, this.serverModuleKey, (ISonarLintFile)issuable);
                    Collection serverIssuesTrackable = serverIssues.stream().map(ServerIssueTrackable::new).collect(Collectors.toList());
                    Collection<Trackable> tracked = issueTracker.matchAndTrackServerIssues(relativePath, serverIssuesTrackable);
                    issueTracker.updateCache(relativePath, tracked);
                    trackedIssues.put(issuable, tracked);
                }
                if (!trackedIssues.isEmpty()) {
                    new AsyncServerMarkerUpdaterJob(this.project, trackedIssues, this.docPerFile, this.triggerType).schedule();
                }
                return Status.OK_STATUS;
            }
            catch (Throwable t) {
                SonarLintLogger.get().error("Error while fetching and matching server issues", t);
                return new Status(4, "org.sonarlint.eclipse.core", t.getMessage());
            }
        }
    }
}

