/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.tracking;

import java.util.List;
import javax.annotation.Nullable;
import org.sonarlint.eclipse.core.internal.markers.TextRange;
import org.sonarlint.eclipse.core.internal.tracking.DigestUtils;
import org.sonarlint.eclipse.core.internal.tracking.Trackable;
import org.sonarsource.sonarlint.core.client.api.common.analysis.Issue;

public class RawIssueTrackable
implements Trackable {
    private final Issue issue;
    private final TextRange textRange;
    private final Integer textRangeHash;
    private final Integer lineHash;
    private Long markerId;

    public RawIssueTrackable(Issue issue) {
        this(issue, null, null, null);
    }

    public RawIssueTrackable(Issue issue, @Nullable TextRange textRange, @Nullable String textRangeContent, @Nullable String lineContent) {
        this.issue = issue;
        this.textRange = textRange;
        this.textRangeHash = textRangeContent != null ? Integer.valueOf(RawIssueTrackable.checksum(textRangeContent)) : null;
        this.lineHash = lineContent != null ? Integer.valueOf(RawIssueTrackable.checksum(lineContent)) : null;
    }

    @Override
    public Long getMarkerId() {
        return this.markerId;
    }

    @Override
    public void setMarkerId(Long id) {
        this.markerId = id;
    }

    private static int checksum(String content) {
        return DigestUtils.digest(content).hashCode();
    }

    @Override
    public Integer getLine() {
        return this.issue.getStartLine();
    }

    @Override
    public String getMessage() {
        return this.issue.getMessage();
    }

    @Override
    public Integer getTextRangeHash() {
        return this.textRangeHash;
    }

    @Override
    public Integer getLineHash() {
        return this.lineHash;
    }

    @Override
    public String getRuleKey() {
        return this.issue.getRuleKey();
    }

    @Override
    public String getRuleName() {
        return this.issue.getRuleName();
    }

    @Override
    public String getSeverity() {
        return this.issue.getSeverity();
    }

    @Override
    public String getRawSeverity() {
        return this.issue.getSeverity();
    }

    @Override
    public String getType() {
        return this.issue.getType();
    }

    @Override
    public String getRawType() {
        return this.issue.getType();
    }

    @Override
    public TextRange getTextRange() {
        return this.textRange;
    }

    @Override
    public String getServerIssueKey() {
        return null;
    }

    @Override
    public Long getCreationDate() {
        return null;
    }

    @Override
    public boolean isResolved() {
        return false;
    }

    @Override
    public String getAssignee() {
        return "";
    }

    @Override
    public List<Issue.Flow> getFlows() {
        return this.issue.flows();
    }
}

