/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.tracking;

import org.sonarlint.eclipse.core.internal.tracking.Trackable;
import org.sonarlint.eclipse.core.internal.tracking.WrappedTrackable;
import org.sonarlint.eclipse.core.internal.utils.StringUtils;

public class PreviousTrackable
extends WrappedTrackable {
    private final String serverIssueKey;
    private final Long creationDate;
    private final boolean resolved;
    private final String assignee;
    private final String severity;
    private final String type;
    private Long markerId;

    public PreviousTrackable(Trackable base, Trackable raw) {
        super(raw);
        this.serverIssueKey = base.getServerIssueKey();
        this.creationDate = base.getCreationDate();
        this.resolved = base.isResolved();
        this.assignee = base.getAssignee();
        this.markerId = base.getMarkerId();
        this.severity = StringUtils.isBlank(base.getSeverity()) ? raw.getSeverity() : base.getSeverity();
        this.type = StringUtils.isBlank(base.getType()) ? raw.getType() : base.getType();
    }

    @Override
    public String getServerIssueKey() {
        return this.serverIssueKey;
    }

    @Override
    public Long getCreationDate() {
        return this.creationDate;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public String getAssignee() {
        return this.assignee;
    }

    @Override
    public Long getMarkerId() {
        return this.markerId;
    }

    @Override
    public void setMarkerId(Long markerId) {
        this.markerId = markerId;
    }

    @Override
    public String getSeverity() {
        return this.severity;
    }

    @Override
    public String getType() {
        return this.type;
    }
}

