/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.tracking;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.sonarlint.eclipse.core.internal.tracking.IssueTracker;
import org.sonarlint.eclipse.core.internal.tracking.IssueTrackerCacheFactory;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;

public class IssueTrackerRegistry {
    private final Map<String, IssueTracker> registry = new HashMap<String, IssueTracker>();
    private final IssueTrackerCacheFactory cacheFactory;

    public IssueTrackerRegistry(IssueTrackerCacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    public synchronized IssueTracker getOrCreate(ISonarLintProject project, String localModulePath) {
        IssueTracker tracker = this.registry.get(project.getName());
        if (tracker == null) {
            tracker = this.newTracker(project, localModulePath);
            this.registry.put(project.getName(), tracker);
        }
        return tracker;
    }

    public synchronized Optional<IssueTracker> get(ISonarLintProject project) {
        return Optional.ofNullable(this.registry.get(project.getName()));
    }

    private IssueTracker newTracker(ISonarLintProject project, String localModulePath) {
        return new IssueTracker(this.cacheFactory.apply(project, localModulePath));
    }

    public void shutdown() {
        for (IssueTracker issueTracker : this.registry.values()) {
            issueTracker.shutdown();
        }
    }
}

