/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.tracking;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.sonarlint.eclipse.core.internal.proto.Sonarlint;
import org.sonarlint.eclipse.core.internal.tracking.IndexedObjectStore;
import org.sonarlint.eclipse.core.internal.tracking.PathStoreKeyValidator;
import org.sonarlint.eclipse.core.internal.tracking.ProtobufIssueTrackable;
import org.sonarlint.eclipse.core.internal.tracking.StringStoreIndex;
import org.sonarlint.eclipse.core.internal.tracking.Trackable;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarsource.sonarlint.core.client.api.connected.objectstore.HashingPathMapper;
import org.sonarsource.sonarlint.core.client.api.connected.objectstore.PathMapper;
import org.sonarsource.sonarlint.core.client.api.connected.objectstore.Reader;
import org.sonarsource.sonarlint.core.client.api.connected.objectstore.Writer;
import org.sonarsource.sonarlint.core.client.api.util.FileUtils;

public class IssueStore {
    private Path basePath;
    private IndexedObjectStore<String, Sonarlint.Issues> store;

    public IssueStore(Path storeBasePath, ISonarLintProject project) {
        this.basePath = storeBasePath;
        FileUtils.mkdirs((Path)storeBasePath);
        StringStoreIndex index = new StringStoreIndex(storeBasePath);
        HashingPathMapper mapper = new HashingPathMapper(storeBasePath, 2);
        PathStoreKeyValidator validator = new PathStoreKeyValidator(project);
        Reader reader = is -> {
            try {
                return Sonarlint.Issues.parseFrom(is);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to read issues", e);
            }
        };
        Writer writer = (os, issues) -> {
            try {
                issues.writeTo(os);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to save issues", e);
            }
        };
        this.store = new IndexedObjectStore(index, (PathMapper<String>)mapper, reader, writer, validator);
        this.store.deleteInvalid();
    }

    public boolean contains(String key) {
        return this.store.contains(key);
    }

    public void save(String key, Collection<Trackable> issues) throws IOException {
        this.store.write(key, IssueStore.transform(issues));
    }

    @CheckForNull
    public Collection<Trackable> read(String key) throws IOException {
        Optional<Sonarlint.Issues> issues = this.store.read(key);
        if (issues.isPresent()) {
            return IssueStore.transform(issues.get());
        }
        return null;
    }

    public void clean() {
        this.store.deleteInvalid();
    }

    public void clear() {
        FileUtils.deleteRecursively((Path)this.basePath);
        FileUtils.mkdirs((Path)this.basePath);
    }

    private static Collection<Trackable> transform(Sonarlint.Issues protoIssues) {
        return protoIssues.getIssueList().stream().map(IssueStore::transform).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Sonarlint.Issues transform(Collection<Trackable> localIssues) {
        Sonarlint.Issues.Builder builder = Sonarlint.Issues.newBuilder();
        localIssues.stream().map(IssueStore::transform).filter(Objects::nonNull).forEach(builder::addIssue);
        return builder.build();
    }

    private static Trackable transform(Sonarlint.Issues.Issue issue) {
        return new ProtobufIssueTrackable(issue);
    }

    @CheckForNull
    private static Sonarlint.Issues.Issue transform(Trackable localIssue) {
        Sonarlint.Issues.Issue.Builder builder = Sonarlint.Issues.Issue.newBuilder().setRuleKey(localIssue.getRuleKey()).setMessage(localIssue.getMessage()).setResolved(localIssue.isResolved()).setSeverity(localIssue.getSeverity()).setType(localIssue.getType());
        if (localIssue.getAssignee() != null) {
            builder.setAssignee(localIssue.getAssignee());
        }
        if (localIssue.getCreationDate() != null) {
            builder.setCreationDate(localIssue.getCreationDate());
        }
        if (localIssue.getLineHash() != null) {
            builder.setChecksum(localIssue.getLineHash());
        }
        if (localIssue.getServerIssueKey() != null) {
            builder.setServerIssueKey(localIssue.getServerIssueKey());
        }
        if (localIssue.getLine() != null) {
            builder.setLine(localIssue.getLine());
        }
        if (localIssue.getMarkerId() != null) {
            builder.setMarkerId(localIssue.getMarkerId());
        }
        return builder.build();
    }
}

