/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.tracking;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Optional;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.internal.tracking.StoreIndex;
import org.sonarlint.eclipse.core.internal.tracking.StoreKeyValidator;
import org.sonarsource.sonarlint.core.client.api.connected.objectstore.ObjectStore;
import org.sonarsource.sonarlint.core.client.api.connected.objectstore.PathMapper;
import org.sonarsource.sonarlint.core.client.api.connected.objectstore.Reader;
import org.sonarsource.sonarlint.core.client.api.connected.objectstore.Writer;

class IndexedObjectStore<K, V>
implements ObjectStore<K, V> {
    private final StoreIndex<K> index;
    private final PathMapper<K> pathMapper;
    private final Reader<V> reader;
    private final Writer<V> writer;
    private final StoreKeyValidator<K> validator;

    IndexedObjectStore(StoreIndex<K> index, PathMapper<K> pathMapper, Reader<V> reader, Writer<V> writer, StoreKeyValidator<K> validator) {
        this.index = index;
        this.pathMapper = pathMapper;
        this.reader = reader;
        this.writer = writer;
        this.validator = validator;
    }

    public Optional<V> read(K key) throws IOException {
        Path path = (Path)this.pathMapper.apply(key);
        if (!path.toFile().exists()) {
            return Optional.empty();
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            return Optional.of(this.reader.apply((Object)inputStream));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public boolean contains(K key) {
        Path path = (Path)this.pathMapper.apply(key);
        return path.toFile().exists();
    }

    public void deleteInvalid() {
        int counter = 0;
        Collection<K> keys = this.index.keys();
        for (K k : keys) {
            if (((Boolean)this.validator.apply(k)).booleanValue()) continue;
            try {
                ++counter;
                this.delete(k);
            }
            catch (IOException e) {
                SonarLintLogger.get().error("Failed to delete file in the store", e);
            }
        }
        SonarLintLogger.get().debug(String.format("%d entries removed from the store", counter));
    }

    public void delete(K key) throws IOException {
        Path path = (Path)this.pathMapper.apply(key);
        Files.deleteIfExists(path);
        this.index.delete(key);
    }

    public void write(K key, V value) throws IOException {
        Path path = (Path)this.pathMapper.apply(key);
        this.index.save(key, path);
        Path parent = path.getParent();
        if (!parent.toFile().exists()) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
            this.writer.accept((Object)out, value);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

