/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.telemetry;

import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.event.AnalysisEvent;
import org.sonarlint.eclipse.core.internal.event.AnalysisListener;
import org.sonarlint.eclipse.core.internal.resources.ProjectsProviderUtils;
import org.sonarsource.sonarlint.core.client.api.common.TelemetryClientConfig;
import org.sonarsource.sonarlint.core.client.api.util.SonarLintUtils;
import org.sonarsource.sonarlint.core.telemetry.TelemetryClient;
import org.sonarsource.sonarlint.core.telemetry.TelemetryManager;
import org.sonarsource.sonarlint.core.telemetry.TelemetryPathManager;

public class SonarLintTelemetry
implements AnalysisListener {
    private static final String TELEMETRY_PRODUCT_KEY = "eclipse";
    private static final String PRODUCT = "SonarLint Eclipse";
    private static final String OLD_STORAGE_FILENAME = "sonarlint_usage";
    public static final String DISABLE_PROPERTY_KEY = "sonarlint.telemetry.disabled";
    private TelemetryManager telemetry;
    private TelemetryJob scheduledJob;

    static Path getStorageFilePath() {
        TelemetryPathManager.migrate((String)TELEMETRY_PRODUCT_KEY, (Path)SonarLintTelemetry.getOldStorageFilePath());
        return TelemetryPathManager.getPath((String)TELEMETRY_PRODUCT_KEY);
    }

    private static Path getOldStorageFilePath() {
        return SonarLintCorePlugin.getInstance().getStateLocation().toFile().toPath().resolve(OLD_STORAGE_FILENAME);
    }

    public void optOut(boolean optOut) {
        if (this.telemetry != null) {
            if (optOut) {
                if (this.telemetry.isEnabled()) {
                    this.telemetry.disable();
                }
            } else if (!this.telemetry.isEnabled()) {
                this.telemetry.enable();
            }
        }
    }

    public boolean enabled() {
        return this.telemetry != null && this.telemetry.isEnabled();
    }

    public void init() {
        block3: {
            if ("true".equals(System.getProperty(DISABLE_PROPERTY_KEY))) {
                SonarLintLogger.get().info("Telemetry disabled by system property");
                return;
            }
            try {
                TelemetryClientConfig clientConfig = SonarLintTelemetry.getTelemetryClientConfig();
                TelemetryClient client = new TelemetryClient(clientConfig, PRODUCT, org.sonarlint.eclipse.core.internal.utils.SonarLintUtils.getPluginVersion());
                this.telemetry = this.newTelemetryManager(SonarLintTelemetry.getStorageFilePath(), client);
                SonarLintCorePlugin.getAnalysisListenerManager().addListener(this);
                this.scheduledJob = new TelemetryJob();
                this.scheduledJob.schedule(TimeUnit.MINUTES.toMillis(1L));
            }
            catch (Exception e) {
                if (!SonarLintUtils.isInternalDebugEnabled()) break block3;
                SonarLintLogger.get().error("Failed during periodic telemetry job", e);
            }
        }
    }

    public TelemetryManager newTelemetryManager(Path path, TelemetryClient client) {
        return new TelemetryManager(path, client);
    }

    public static TelemetryClientConfig getTelemetryClientConfig() {
        IProxyData[] proxyDataForHost;
        TelemetryClientConfig.Builder clientConfigBuilder = new TelemetryClientConfig.Builder().userAgent("SonarLint");
        IProxyService proxyService = SonarLintCorePlugin.getInstance().getProxyService();
        try {
            proxyDataForHost = proxyService.select(new URL("https://chestnutsl.sonarsource.com").toURI());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        IProxyData[] iProxyDataArray = proxyDataForHost;
        int n = proxyDataForHost.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyData data = iProxyDataArray[n2];
            if (data.getHost() != null) {
                clientConfigBuilder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(data.getHost(), data.getPort())));
                if (!data.isRequiresAuthentication()) break;
                clientConfigBuilder.proxyLogin(data.getUserId());
                clientConfigBuilder.proxyPassword(data.getPassword());
                break;
            }
            ++n2;
        }
        return clientConfigBuilder.build();
    }

    public void upload() {
        if (this.enabled()) {
            this.telemetry.usedConnectedMode(SonarLintTelemetry.isAnyProjectConnected());
            this.telemetry.uploadLazily();
        }
    }

    @Override
    public void usedAnalysis(AnalysisEvent event) {
        if (this.enabled()) {
            this.telemetry.usedAnalysis();
        }
    }

    public void stop() {
        SonarLintCorePlugin.getAnalysisListenerManager().removeListener(this);
        if (this.scheduledJob != null) {
            this.scheduledJob.cancel();
            this.scheduledJob = null;
        }
        if (this.enabled()) {
            this.telemetry.stop();
        }
    }

    private static boolean isAnyProjectConnected() {
        return ProjectsProviderUtils.allProjects().stream().anyMatch(p -> p.isOpen() && p.isBound());
    }

    public Job getScheduledJob() {
        return this.scheduledJob;
    }

    private class TelemetryJob
    extends Job {
        public TelemetryJob() {
            super("SonarLint Telemetry");
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.schedule(TimeUnit.HOURS.toMillis(6L));
            SonarLintTelemetry.this.upload();
            return Status.OK_STATUS;
        }
    }
}

