/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.resources;

import javax.annotation.Nullable;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.IAdaptable;
import org.sonarlint.eclipse.core.internal.adapter.Adapters;
import org.sonarlint.eclipse.core.resource.ISonarLintFile;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;

public class SonarLintPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, @Nullable Object expectedValue) {
        ISonarLintProject project = SonarLintPropertyTester.getProject(receiver);
        if (project == null) {
            return false;
        }
        if ("bound".equals(property)) {
            return expectedValue == null ? project.isBound() : project.isBound() == ((Boolean)expectedValue).booleanValue();
        }
        if ("autoAnalysisEnabled".equals(property)) {
            return expectedValue == null ? project.isAutoEnabled() : project.isAutoEnabled() == ((Boolean)expectedValue).booleanValue();
        }
        if ("open".equals(property)) {
            return expectedValue == null ? project.isOpen() : project.isOpen() == ((Boolean)expectedValue).booleanValue();
        }
        return false;
    }

    private static ISonarLintProject getProject(Object receiver) {
        if (receiver instanceof ISonarLintProject) {
            return (ISonarLintProject)receiver;
        }
        if (receiver instanceof ISonarLintFile) {
            return ((ISonarLintFile)receiver).getProject();
        }
        if (receiver instanceof IAdaptable) {
            ISonarLintProject project = Adapters.adapt(receiver, ISonarLintProject.class);
            if (project != null) {
                return project;
            }
            ISonarLintFile file = Adapters.adapt(receiver, ISonarLintFile.class);
            if (file != null) {
                return file.getProject();
            }
        }
        return null;
    }
}

