/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.resources;

import java.util.ArrayList;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.service.prefs.BackingStoreException;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProjectConfiguration;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProperty;
import org.sonarlint.eclipse.core.internal.utils.StringUtils;

public class SonarLintProjectManager {
    private static final String P_EXTRA_PROPS = "extraProperties";
    private static final String P_SERVER_ID = "serverId";
    private static final String P_PROJECT_KEY = "projectKey";
    private static final String P_MODULE_KEY = "moduleKey";
    private static final String P_AUTO_ENABLED_KEY = "autoEnabled";

    public SonarLintProjectConfiguration readSonarLintConfiguration(IScopeContext projectScope) {
        IEclipsePreferences projectNode = projectScope.getNode("org.sonarlint.eclipse.core");
        SonarLintProjectConfiguration sonarProject = new SonarLintProjectConfiguration(projectScope);
        if (projectNode == null) {
            return sonarProject;
        }
        String extraArgsAsString = projectNode.get(P_EXTRA_PROPS, null);
        ArrayList<SonarLintProperty> sonarProperties = new ArrayList<SonarLintProperty>();
        if (extraArgsAsString != null) {
            try {
                String[] props;
                String[] stringArray = props = StringUtils.split(extraArgsAsString, "\r\n");
                int n = props.length;
                int n2 = 0;
                while (n2 < n) {
                    String keyValuePair = stringArray[n2];
                    String[] keyValue = keyValuePair.split("=");
                    sonarProperties.add(new SonarLintProperty(keyValue[0], keyValue.length > 1 ? keyValue[1] : ""));
                    ++n2;
                }
            }
            catch (Exception e) {
                SonarLintLogger.get().error("Error while loading SonarLint properties", e);
            }
        }
        sonarProject.setExtraProperties(sonarProperties);
        sonarProject.setProjectKey(projectNode.get(P_PROJECT_KEY, ""));
        sonarProject.setModuleKey(projectNode.get(P_MODULE_KEY, ""));
        sonarProject.setServerId(projectNode.get(P_SERVER_ID, ""));
        sonarProject.setAutoEnabled(projectNode.getBoolean(P_AUTO_ENABLED_KEY, true));
        return sonarProject;
    }

    public boolean saveSonarLintConfiguration(IScopeContext projectScope, SonarLintProjectConfiguration configuration) {
        IEclipsePreferences projectNode = projectScope.getNode("org.sonarlint.eclipse.core");
        if (projectNode == null) {
            return false;
        }
        if (configuration.getExtraProperties() != null) {
            ArrayList<String> keyValuePairs = new ArrayList<String>(configuration.getExtraProperties().size());
            for (SonarLintProperty prop : configuration.getExtraProperties()) {
                keyValuePairs.add(String.valueOf(prop.getName()) + "=" + prop.getValue());
            }
            String props = StringUtils.joinSkipNull(keyValuePairs, "\r\n");
            projectNode.put(P_EXTRA_PROPS, props);
        } else {
            projectNode.remove(P_EXTRA_PROPS);
        }
        if (StringUtils.isNotBlank(configuration.getProjectKey())) {
            projectNode.put(P_PROJECT_KEY, configuration.getProjectKey());
        } else {
            projectNode.remove(P_PROJECT_KEY);
        }
        if (StringUtils.isNotBlank(configuration.getModuleKey())) {
            projectNode.put(P_MODULE_KEY, configuration.getModuleKey());
        } else {
            projectNode.remove(P_MODULE_KEY);
        }
        if (StringUtils.isNotBlank(configuration.getServerId())) {
            projectNode.put(P_SERVER_ID, configuration.getServerId());
        } else {
            projectNode.remove(P_SERVER_ID);
        }
        projectNode.putBoolean(P_AUTO_ENABLED_KEY, configuration.isAutoEnabled());
        try {
            projectNode.flush();
            return true;
        }
        catch (BackingStoreException e) {
            SonarLintLogger.get().error("Failed to save project configuration", e);
            return false;
        }
    }
}

