/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.resources;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProperty;
import org.sonarlint.eclipse.core.internal.utils.StringUtils;

public class SonarLintProjectConfiguration {
    private final IScopeContext projectScope;
    private List<SonarLintProperty> extraProperties = new ArrayList<SonarLintProperty>();
    private String projectKey;
    private String moduleKey;
    private String serverId;
    private boolean autoEnabled = true;

    SonarLintProjectConfiguration(IScopeContext projectScope) {
        this.projectScope = projectScope;
    }

    public static SonarLintProjectConfiguration read(IScopeContext projectScope) {
        return SonarLintCorePlugin.getInstance().getProjectManager().readSonarLintConfiguration(projectScope);
    }

    public void save() {
        SonarLintCorePlugin.getInstance().getProjectManager().saveSonarLintConfiguration(this.projectScope, this);
    }

    public List<SonarLintProperty> getExtraProperties() {
        return this.extraProperties;
    }

    public void setExtraProperties(List<SonarLintProperty> extraProperties) {
        this.extraProperties = extraProperties;
    }

    @CheckForNull
    public String getProjectKey() {
        return StringUtils.trimToNull(this.projectKey);
    }

    @CheckForNull
    public String getModuleKey() {
        return StringUtils.trimToNull(this.moduleKey);
    }

    @CheckForNull
    public String getServerId() {
        return StringUtils.trimToNull(this.serverId);
    }

    public void setProjectKey(@Nullable String projectKey) {
        this.projectKey = projectKey;
    }

    public void setModuleKey(@Nullable String moduleKey) {
        this.moduleKey = moduleKey;
    }

    public void setServerId(@Nullable String serverId) {
        this.serverId = serverId;
    }

    public boolean isBound() {
        return this.getServerId() != null && this.getModuleKey() != null;
    }

    public boolean isAutoEnabled() {
        return this.autoEnabled;
    }

    public void setAutoEnabled(boolean autoEnabled) {
        this.autoEnabled = autoEnabled;
    }

    public void unbind() {
        this.setServerId(null);
        this.setProjectKey(null);
        this.setModuleKey(null);
        this.save();
    }
}

