/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.resources;

import java.nio.charset.Charset;
import java.util.Objects;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.resource.ISonarLintFile;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;

public class DefaultSonarLintFileAdapter
implements ISonarLintFile {
    private final IFile file;
    private final ISonarLintProject project;

    public DefaultSonarLintFileAdapter(ISonarLintProject project, IFile file) {
        this.file = file;
        this.project = project;
    }

    @Override
    public String getName() {
        return this.file.getFullPath().toString();
    }

    @Override
    public ISonarLintProject getProject() {
        return this.project;
    }

    @Override
    public String getProjectRelativePath() {
        return this.file.getProjectRelativePath().toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IDocument getDocument() {
        IDocument iDocument;
        ITextFileBufferManager textFileBufferManager = FileBuffers.getTextFileBufferManager();
        IPath path = this.file.getFullPath();
        try {
            textFileBufferManager.connect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            ITextFileBuffer textFileBuffer = textFileBufferManager.getTextFileBuffer(path, LocationKind.IFILE);
            iDocument = textFileBuffer.getDocument();
        }
        catch (CoreException e) {
            try {
                throw new IllegalStateException("Unable to open content of file " + this.file, e);
            }
            catch (Throwable throwable) {
                try {
                    textFileBufferManager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
                    throw throwable;
                }
                catch (CoreException coreException) {}
                throw throwable;
            }
        }
        try {
            textFileBufferManager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            return iDocument;
        }
        catch (CoreException coreException) {}
        return iDocument;
    }

    @Override
    public IResource getResource() {
        return this.file;
    }

    @Override
    public Charset getCharset() {
        try {
            return Charset.forName(this.file.getCharset());
        }
        catch (CoreException e) {
            SonarLintLogger.get().error("Unable to determine charset of file " + this.file, e);
            return Charset.defaultCharset();
        }
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultSonarLintFileAdapter other = (DefaultSonarLintFileAdapter)obj;
        return Objects.equals(this.file, other.file);
    }
}

