/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.notifications;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public class NotificationsTracker {
    public static final String FILENAME = "lastEventPolling.data";
    private ZonedDateTime lastEventPolling;
    private final Path lastEventPollingPath;

    public NotificationsTracker(Path basedir) {
        if (!basedir.toFile().isDirectory()) {
            try {
                Files.createDirectories(basedir, new FileAttribute[0]);
            }
            catch (IOException iOException) {}
        }
        this.lastEventPollingPath = basedir.resolve(FILENAME);
    }

    public synchronized ZonedDateTime getLastEventPolling() {
        if (this.lastEventPolling == null) {
            this.lastEventPolling = this.readFromFile();
            if (this.lastEventPolling == null) {
                this.lastEventPolling = ZonedDateTime.now();
            }
        }
        return this.lastEventPolling;
    }

    public synchronized void setLastEventPolling(ZonedDateTime time) {
        this.lastEventPolling = time;
        this.writeToFile(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateLastEventPolling(ZonedDateTime time) {
        NotificationsTracker notificationsTracker = this;
        synchronized (notificationsTracker) {
            if (this.lastEventPolling == null || time.isAfter(this.lastEventPolling)) {
                this.setLastEventPolling(time);
            }
        }
    }

    private ZonedDateTime readFromFile() {
        if (!this.lastEventPollingPath.toFile().isFile()) {
            return null;
        }
        try {
            long millis = Long.parseLong(new String(Files.readAllBytes(this.lastEventPollingPath), Charset.defaultCharset()));
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.systemDefault());
        }
        catch (IOException | NumberFormatException exception) {
            return null;
        }
    }

    private void writeToFile(ZonedDateTime time) {
        try {
            Files.write(this.lastEventPollingPath, Long.toString(time.toInstant().toEpochMilli()).getBytes(Charset.defaultCharset()), new OpenOption[0]);
        }
        catch (IOException iOException) {}
    }
}

