/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.notifications;

import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.notifications.NotificationsTracker;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProjectConfiguration;
import org.sonarlint.eclipse.core.internal.server.Server;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarsource.sonarlint.core.client.api.common.NotificationConfiguration;
import org.sonarsource.sonarlint.core.client.api.notifications.LastNotificationTime;
import org.sonarsource.sonarlint.core.client.api.notifications.SonarQubeNotificationListener;
import org.sonarsource.sonarlint.core.notifications.SonarQubeNotifications;

public class NotificationsManager {
    private final Map<String, Set<String>> subscribers = new HashMap<String, Set<String>>();
    private final Map<String, SonarQubeNotificationListener> listeners = new HashMap<String, SonarQubeNotificationListener>();
    private final Subscriber subscriber;
    private final SonarLintProjectConfigurationReader configReader;

    public NotificationsManager() {
        this(new Subscriber(), p -> SonarLintProjectConfiguration.read(p.getScopeContext()));
    }

    public NotificationsManager(Subscriber subscriber, SonarLintProjectConfigurationReader configReader) {
        this.subscriber = subscriber;
        this.configReader = configReader;
    }

    public synchronized void subscribe(ISonarLintProject project, SonarQubeNotificationListener listener) {
        SonarLintProjectConfiguration config = this.configReader.apply(project);
        String projectKey = config.getProjectKey();
        if (projectKey == null) {
            return;
        }
        Set<String> moduleKeys = this.subscribers.get(projectKey);
        if (moduleKeys == null) {
            if (!this.subscriber.subscribe(project, config, listener)) {
                return;
            }
            moduleKeys = new HashSet<String>();
            this.subscribers.put(projectKey, moduleKeys);
            this.listeners.put(projectKey, listener);
        }
        String moduleKey = config.getModuleKey();
        moduleKeys.add(moduleKey);
    }

    public synchronized void unsubscribe(ISonarLintProject project) {
        SonarLintProjectConfiguration config = this.configReader.apply(project);
        String projectKey = config.getProjectKey();
        Set<String> moduleKeys = this.subscribers.get(projectKey);
        if (moduleKeys == null) {
            return;
        }
        String moduleKey = config.getModuleKey();
        moduleKeys.remove(moduleKey);
        if (moduleKeys.isEmpty()) {
            this.subscribers.remove(projectKey);
            this.subscriber.unsubscribe(this.listeners.remove(projectKey));
        }
    }

    public static class ProjectNotificationTime
    implements LastNotificationTime {
        private final NotificationsTracker tracker;

        public ProjectNotificationTime(NotificationsTracker tracker) {
            this.tracker = tracker;
        }

        public ProjectNotificationTime(ISonarLintProject project) {
            this(SonarLintCorePlugin.getOrCreateNotificationsTracker(project));
        }

        public ZonedDateTime get() {
            return this.tracker.getLastEventPolling();
        }

        public void set(ZonedDateTime dateTime) {
            this.tracker.updateLastEventPolling(dateTime);
        }
    }

    public static interface SonarLintProjectConfigurationReader
    extends Function<ISonarLintProject, SonarLintProjectConfiguration> {
        @Override
        public SonarLintProjectConfiguration apply(ISonarLintProject var1);
    }

    public static class Subscriber {
        public boolean subscribe(ISonarLintProject project, SonarLintProjectConfiguration config, SonarQubeNotificationListener listener) {
            Server server = (Server)SonarLintCorePlugin.getServersManager().getServer(config.getServerId());
            if (server == null || !server.areNotificationsEnabled()) {
                return false;
            }
            ProjectNotificationTime notificationTime = new ProjectNotificationTime(project);
            NotificationConfiguration configuration = new NotificationConfiguration(listener, (LastNotificationTime)notificationTime, config.getProjectKey(), server.getConfig());
            SonarQubeNotifications.get().register(configuration);
            return true;
        }

        public void unsubscribe(SonarQubeNotificationListener listener) {
            SonarQubeNotifications.get().remove(listener);
        }
    }
}

