/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.jobs;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.annotation.CheckForNull;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.jobs.SonarLintAnalyzerLogOutput;
import org.sonarlint.eclipse.core.internal.jobs.WrappedProgressMonitor;
import org.sonarlint.eclipse.core.internal.utils.SonarLintUtils;
import org.sonarsource.sonarlint.core.StandaloneSonarLintEngineImpl;
import org.sonarsource.sonarlint.core.client.api.common.LogOutput;
import org.sonarsource.sonarlint.core.client.api.common.ProgressMonitor;
import org.sonarsource.sonarlint.core.client.api.common.RuleDetails;
import org.sonarsource.sonarlint.core.client.api.common.analysis.AnalysisResults;
import org.sonarsource.sonarlint.core.client.api.common.analysis.IssueListener;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneAnalysisConfiguration;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneGlobalConfiguration;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneSonarLintEngine;

public class StandaloneSonarLintClientFacade {
    private StandaloneSonarLintEngine client;

    @CheckForNull
    private synchronized StandaloneSonarLintEngine getClient() {
        if (this.client == null) {
            SonarLintLogger.get().info("Starting standalone SonarLint engine " + SonarLintUtils.getPluginVersion() + "...");
            Enumeration pluginEntriesEnum = SonarLintCorePlugin.getInstance().getBundle().findEntries("/plugins", "*.jar", false);
            if (pluginEntriesEnum != null) {
                ArrayList<URL> pluginEntries = Collections.list(pluginEntriesEnum);
                SonarLintLogger.get().debug("Loading embedded analyzers...");
                pluginEntries.stream().forEach(e -> SonarLintLogger.get().debug("  - " + e.getFile()));
                StandaloneGlobalConfiguration globalConfig = ((StandaloneGlobalConfiguration.Builder)((StandaloneGlobalConfiguration.Builder)StandaloneGlobalConfiguration.builder().addPlugins(pluginEntries.toArray(new URL[0])).setWorkDir(ResourcesPlugin.getWorkspace().getRoot().getLocation().append(".sonarlint").append("default").toFile().toPath())).setLogOutput((LogOutput)new SonarLintAnalyzerLogOutput())).build();
                try {
                    this.client = new StandaloneSonarLintEngineImpl(globalConfig);
                }
                catch (Throwable e2) {
                    SonarLintLogger.get().error("Unable to start standalone SonarLint engine", e2);
                    this.client = null;
                }
            } else {
                throw new IllegalStateException("Unable to find any embedded plugin");
            }
        }
        return this.client;
    }

    @CheckForNull
    public AnalysisResults runAnalysis(StandaloneAnalysisConfiguration config, IssueListener issueListener, IProgressMonitor monitor) {
        StandaloneSonarLintEngine engine = this.getClient();
        if (engine != null) {
            return engine.analyze(config, issueListener, null, (ProgressMonitor)new WrappedProgressMonitor(monitor, "Analysis"));
        }
        return null;
    }

    @CheckForNull
    public RuleDetails getRuleDescription(String ruleKey) {
        StandaloneSonarLintEngine engine = this.getClient();
        if (engine != null) {
            return engine.getRuleDetails(ruleKey);
        }
        return null;
    }

    public synchronized void stop() {
        if (this.client != null) {
            this.client.stop();
            this.client = null;
        }
    }
}

