/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.jobs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sonarlint.eclipse.core.resource.ISonarLintIssuable;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarsource.sonarlint.core.client.api.common.analysis.ClientInputFile;
import org.sonarsource.sonarlint.core.client.api.common.analysis.Issue;
import org.sonarsource.sonarlint.core.client.api.common.analysis.IssueListener;

public class SonarLintIssueListener
implements IssueListener {
    private final Map<ISonarLintIssuable, List<Issue>> issuesPerResource;
    private final ISonarLintProject project;
    private long issueCount = 0L;

    public SonarLintIssueListener(ISonarLintProject project, Map<ISonarLintIssuable, List<Issue>> issuesPerResource) {
        this.issuesPerResource = issuesPerResource;
        this.project = project;
    }

    public void handle(Issue issue) {
        ++this.issueCount;
        ClientInputFile inputFile = issue.getInputFile();
        ISonarLintIssuable r = inputFile == null ? this.project : (ISonarLintIssuable)inputFile.getClientObject();
        if (!this.issuesPerResource.containsKey(r)) {
            this.issuesPerResource.put(r, new ArrayList());
        }
        this.issuesPerResource.get(r).add(issue);
    }

    public long getIssueCount() {
        return this.issueCount;
    }
}

