/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.jobs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProjectConfiguration;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarsource.sonarlint.core.client.api.connected.RemoteModule;

public class ServerUpdateJob
extends Job {
    private final IServer server;

    public ServerUpdateJob(IServer server) {
        super("Update data from SonarQube server '" + server.getId() + "'");
        this.server = server;
    }

    protected IStatus run(IProgressMonitor monitor) {
        List<ISonarLintProject> projectsToUpdate = this.server.getBoundProjects();
        monitor.beginTask("Update server and all associated projects", projectsToUpdate.size() + 1);
        try {
            this.server.updateStorage(monitor);
        }
        catch (Exception e) {
            return new Status(4, "org.sonarlint.eclipse.core", "Unable to update data from server '" + this.server.getId() + "'", (Throwable)e);
        }
        monitor.worked(1);
        HashSet<String> seenModuleKeys = new HashSet<String>();
        ArrayList<Status> failures = new ArrayList<Status>();
        for (ISonarLintProject projectToUpdate : projectsToUpdate) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            try {
                SonarLintProjectConfiguration config = SonarLintProjectConfiguration.read(projectToUpdate.getScopeContext());
                this.fixProjectKeyIfMissing(config);
                if (seenModuleKeys.add(config.getModuleKey())) {
                    this.server.updateProjectStorage(config.getModuleKey(), monitor);
                }
            }
            catch (Exception e) {
                failures.add(new Status(4, "org.sonarlint.eclipse.core", "Unable to update binding for project '" + projectToUpdate.getName() + "'", (Throwable)e));
            }
            monitor.worked(1);
        }
        monitor.done();
        if (!failures.isEmpty()) {
            return new MultiStatus("org.sonarlint.eclipse.core", 4, failures.toArray(new IStatus[0]), "Failed to update binding for " + failures.size() + " project(s)", null);
        }
        return Status.OK_STATUS;
    }

    private void fixProjectKeyIfMissing(SonarLintProjectConfiguration config) {
        RemoteModule remoteModule;
        if (config.getProjectKey() == null && (remoteModule = this.server.getRemoteModules().get(config.getModuleKey())) != null) {
            config.setProjectKey(remoteModule.getProjectKey());
            config.save();
        }
    }
}

