/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.jobs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.annotation.Nullable;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.text.IDocument;
import org.sonarlint.eclipse.core.resource.ISonarLintFile;
import org.sonarsource.sonarlint.core.client.api.common.analysis.ClientInputFile;

class EclipseInputFile
implements ClientInputFile {
    private final List<PathMatcher> pathMatchersForTests;
    private final ISonarLintFile file;
    private final String language;
    private final IDocument editorDocument;
    private final Path tempDirectory;
    private Path filePath;

    EclipseInputFile(List<PathMatcher> pathMatchersForTests, ISonarLintFile file, Path tempDirectory, @Nullable IDocument editorDocument, @Nullable String language) {
        this.pathMatchersForTests = pathMatchersForTests;
        this.file = file;
        this.tempDirectory = tempDirectory;
        this.language = language;
        this.editorDocument = editorDocument;
    }

    public String getPath() {
        if (this.filePath == null) {
            this.initFromFS(this.file, this.tempDirectory);
        }
        return this.filePath.toString();
    }

    private synchronized void initFromFS(ISonarLintFile file, Path temporaryDirectory) {
        try {
            IFileStore fileStore = EFS.getStore((URI)file.getResource().getLocationURI());
            File localFile = fileStore.toLocalFile(0, null);
            if (localFile == null) {
                localFile = new File(temporaryDirectory.toFile(), file.getProjectRelativePath());
                Files.createDirectories(localFile.getParentFile().toPath(), new FileAttribute[0]);
                fileStore.copy(EFS.getStore((URI)localFile.toURI()), 2, null);
            }
            this.filePath = localFile.toPath().toAbsolutePath();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to find path for file " + file, e);
        }
    }

    public boolean isTest() {
        Path absolutePath = Paths.get(this.file.getProject().getName(), new String[0]).resolve(this.file.getProjectRelativePath());
        for (PathMatcher matcher : this.pathMatchersForTests) {
            if (!matcher.matches(absolutePath)) continue;
            return true;
        }
        return false;
    }

    public String language() {
        return this.language;
    }

    public Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    public <G> G getClientObject() {
        return (G)this.file;
    }

    public URI uri() {
        return this.file.uri();
    }

    public String contents() throws IOException {
        if (this.editorDocument != null) {
            return this.editorDocument.get();
        }
        return this.file.getDocument().get();
    }

    public InputStream inputStream() throws IOException {
        return new ByteArrayInputStream(this.contents().getBytes(this.getCharset()));
    }
}

