/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.jobs;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.IDocument;
import org.sonarlint.eclipse.core.internal.TriggerType;
import org.sonarlint.eclipse.core.internal.jobs.AbstractSonarProjectJob;
import org.sonarlint.eclipse.core.internal.jobs.SonarLintMarkerUpdater;
import org.sonarlint.eclipse.core.internal.tracking.Trackable;
import org.sonarlint.eclipse.core.resource.ISonarLintFile;
import org.sonarlint.eclipse.core.resource.ISonarLintIssuable;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;

public class AsyncServerMarkerUpdaterJob
extends AbstractSonarProjectJob {
    private final Map<ISonarLintIssuable, Collection<Trackable>> issuesPerResource;
    private final TriggerType triggerType;
    private final Map<ISonarLintFile, IDocument> docPerFile;

    public AsyncServerMarkerUpdaterJob(ISonarLintProject project, Map<ISonarLintIssuable, Collection<Trackable>> issuesPerResource, Map<ISonarLintFile, IDocument> docPerFile, TriggerType triggerType) {
        super("Update SonarLint markers based on server side issues", project);
        this.issuesPerResource = issuesPerResource;
        this.docPerFile = docPerFile;
        this.triggerType = triggerType;
    }

    @Override
    protected IStatus doRun(IProgressMonitor monitor) {
        for (Map.Entry<ISonarLintIssuable, Collection<Trackable>> entry : this.issuesPerResource.entrySet()) {
            ISonarLintIssuable issuable = entry.getKey();
            if (!(issuable instanceof ISonarLintFile)) continue;
            IDocument documentOrNull = this.docPerFile.get((ISonarLintFile)issuable);
            IDocument documentNotNull = documentOrNull == null ? ((ISonarLintFile)issuable).getDocument() : documentOrNull;
            ISchedulingRule markerRule = ResourcesPlugin.getWorkspace().getRuleFactory().markerRule(issuable.getResource());
            try {
                AsyncServerMarkerUpdaterJob.getJobManager().beginRule(markerRule, monitor);
                SonarLintMarkerUpdater.updateMarkersWithServerSideData(issuable, documentNotNull, entry.getValue(), this.triggerType, documentOrNull != null);
            }
            finally {
                AsyncServerMarkerUpdaterJob.getJobManager().endRule(markerRule);
            }
        }
        return Status.OK_STATUS;
    }
}

