/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.jobs;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.internal.TriggerType;
import org.sonarlint.eclipse.core.internal.jobs.AnalyzeProjectJob;
import org.sonarlint.eclipse.core.internal.jobs.AnalyzeProjectRequest;
import org.sonarlint.eclipse.core.internal.resources.ProjectsProviderUtils;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;

public class AnalyzeProjectsJob
extends WorkspaceJob {
    private static final String UNABLE_TO_ANALYZE_FILES = "Unable to analyze files";
    private final Map<ISonarLintProject, Collection<AnalyzeProjectRequest.FileWithDocument>> filesPerProject;

    public AnalyzeProjectsJob(Map<ISonarLintProject, Collection<AnalyzeProjectRequest.FileWithDocument>> filesPerProject) {
        super("Analyze all files");
        this.filesPerProject = filesPerProject;
        this.setPriority(30);
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        SubMonitor global = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            global.setTaskName("Analysis");
            ProjectsProviderUtils.allProjects().stream().filter(ISonarLintProject::isOpen).forEach(p -> p.deleteAllMarkers("org.sonarlint.eclipse.core.sonarlintReportProblem"));
            SubMonitor analysisMonitor = SubMonitor.convert((IProgressMonitor)global.newChild(100), (int)this.filesPerProject.size());
            for (Map.Entry<ISonarLintProject, Collection<AnalyzeProjectRequest.FileWithDocument>> entry : this.filesPerProject.entrySet()) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                ISonarLintProject project = entry.getKey();
                if (!project.isOpen()) {
                    analysisMonitor.worked(1);
                    continue;
                }
                global.setTaskName("Analysing project " + project.getName());
                AnalyzeProjectRequest req = new AnalyzeProjectRequest(project, entry.getValue(), TriggerType.MANUAL);
                AnalyzeProjectJob job = new AnalyzeProjectJob(req);
                SubMonitor subMonitor = analysisMonitor.newChild(1);
                job.runInWorkspace((IProgressMonitor)subMonitor);
                subMonitor.done();
            }
        }
        catch (Exception e) {
            SonarLintLogger.get().error(UNABLE_TO_ANALYZE_FILES, e);
            return new Status(4, "org.sonarlint.eclipse.core", UNABLE_TO_ANALYZE_FILES, (Throwable)e);
        }
        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }
}

