/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.jobs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.internal.TriggerType;
import org.sonarlint.eclipse.core.internal.jobs.AnalyzeProjectJob;
import org.sonarlint.eclipse.core.internal.jobs.AnalyzeProjectRequest;
import org.sonarlint.eclipse.core.internal.resources.DefaultSonarLintProjectAdapter;
import org.sonarlint.eclipse.core.internal.resources.ProjectsProviderUtils;
import org.sonarlint.eclipse.core.resource.ISonarLintFile;
import org.sonarlint.eclipse.core.resource.ISonarLintIssuable;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;

public class AnalyzeChangedFilesJob
extends WorkspaceJob {
    private static final String UNABLE_TO_ANALYZE_CHANGED_FILES = "Unable to analyze changed files";
    private final Collection<ISonarLintProject> projects;

    public AnalyzeChangedFilesJob(Collection<ISonarLintProject> projects) {
        super("Analyze changed files");
        this.projects = projects;
        this.setPriority(30);
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        SubMonitor global = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            global.setTaskName("Collect changed file(s) list");
            ProjectsProviderUtils.allProjects().stream().filter(ISonarLintProject::isOpen).forEach(p -> p.deleteAllMarkers("org.sonarlint.eclipse.core.sonarlintReportProblem"));
            Collection<ISonarLintFile> collectChangedFiles = AnalyzeChangedFilesJob.collectChangedFiles(this.projects, (IProgressMonitor)global.newChild(20));
            if (collectChangedFiles.isEmpty()) {
                SonarLintLogger.get().info("No changed files found");
                return Status.OK_STATUS;
            }
            Map<ISonarLintProject, List<ISonarLintFile>> changedFilesPerProject = collectChangedFiles.stream().collect(Collectors.groupingBy(ISonarLintIssuable::getProject));
            long fileCount = changedFilesPerProject.values().stream().flatMap(Collection::stream).count();
            SonarLintLogger.get().info("Analyzing " + fileCount + " changed file(s) in " + changedFilesPerProject.size() + " project(s)");
            global.setTaskName("Analysis");
            SubMonitor analysisMonitor = SubMonitor.convert((IProgressMonitor)global.newChild(80), (int)changedFilesPerProject.size());
            for (Map.Entry<ISonarLintProject, List<ISonarLintFile>> entry : changedFilesPerProject.entrySet()) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                ISonarLintProject project = entry.getKey();
                if (!project.isOpen()) {
                    analysisMonitor.worked(1);
                    continue;
                }
                global.setTaskName("Analysing project " + project.getName());
                Collection filesToAnalyze = entry.getValue().stream().map(f -> new AnalyzeProjectRequest.FileWithDocument((ISonarLintFile)f, null)).collect(Collectors.toList());
                AnalyzeProjectRequest req = new AnalyzeProjectRequest(project, filesToAnalyze, TriggerType.MANUAL_CHANGESET);
                AnalyzeProjectJob job = new AnalyzeProjectJob(req);
                SubMonitor subMonitor = analysisMonitor.newChild(1);
                job.runInWorkspace((IProgressMonitor)subMonitor);
                subMonitor.done();
            }
        }
        catch (Exception e) {
            SonarLintLogger.get().error(UNABLE_TO_ANALYZE_CHANGED_FILES, e);
            return new Status(4, "org.sonarlint.eclipse.core", UNABLE_TO_ANALYZE_CHANGED_FILES, (Throwable)e);
        }
        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }

    private static Collection<ISonarLintFile> collectChangedFiles(Collection<ISonarLintProject> projects, IProgressMonitor monitor) {
        ArrayList<ISonarLintFile> changedFiles = new ArrayList<ISonarLintFile>();
        for (ISonarLintProject project : projects) {
            if (monitor.isCanceled()) break;
            if (!(project instanceof DefaultSonarLintProjectAdapter)) continue;
            changedFiles.addAll(((DefaultSonarLintProjectAdapter)project).getScmChangedFiles(monitor));
        }
        return changedFiles;
    }
}

