/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IFilter;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.analysis.IAnalysisConfigurator;
import org.sonarlint.eclipse.core.analysis.IFileLanguageProvider;
import org.sonarlint.eclipse.core.configurator.ProjectConfigurator;
import org.sonarlint.eclipse.core.resource.ISonarLintFileAdapterParticipant;
import org.sonarlint.eclipse.core.resource.ISonarLintProjectAdapterParticipant;
import org.sonarlint.eclipse.core.resource.ISonarLintProjectsProvider;

public class SonarLintExtensionTracker
implements IExtensionChangeHandler {
    private static final String ATTR_CLASS = "class";
    private final SonarLintEP<ProjectConfigurator> configuratorEp = new SonarLintEP("org.sonarlint.eclipse.core.projectConfigurators");
    private final SonarLintEP<IAnalysisConfigurator> analysisEp = new SonarLintEP("org.sonarlint.eclipse.core.analysisConfigurator");
    private final SonarLintEP<ISonarLintProjectsProvider> projectsProviderEp = new SonarLintEP("org.sonarlint.eclipse.core.projectsProvider");
    private final SonarLintEP<ISonarLintFileAdapterParticipant> fileAdapterParticipantEp = new SonarLintEP("org.sonarlint.eclipse.core.fileAdapterParticipant");
    private final SonarLintEP<ISonarLintProjectAdapterParticipant> projectAdapterParticipantEp = new SonarLintEP("org.sonarlint.eclipse.core.projectAdapterParticipant");
    private final SonarLintEP<IFileLanguageProvider> languageEp = new SonarLintEP("org.sonarlint.eclipse.core.languageProvider");
    private final Collection<SonarLintEP<?>> allEps = Arrays.asList(this.configuratorEp, this.analysisEp, this.projectsProviderEp, this.fileAdapterParticipantEp, this.projectAdapterParticipantEp, this.languageEp);
    private ExtensionTracker tracker;

    public void start() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        this.tracker = new ExtensionTracker(reg);
        IExtensionPoint[] epArray = (IExtensionPoint[])this.allEps.stream().map(ep -> reg.getExtensionPoint(((SonarLintEP)ep).id)).toArray(IExtensionPoint[]::new);
        IFilter filter = ExtensionTracker.createExtensionPointFilter((IExtensionPoint[])epArray);
        this.tracker.registerHandler((IExtensionChangeHandler)this, filter);
        IExtensionPoint[] iExtensionPointArray = epArray;
        int n = epArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtensionPoint ep2 = iExtensionPointArray[n2];
            IExtension[] iExtensionArray = ep2.getExtensions();
            int n3 = iExtensionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IExtension ext = iExtensionArray[n4];
                this.addExtension((IExtensionTracker)this.tracker, ext);
                ++n4;
            }
            ++n2;
        }
    }

    public void close() {
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        IConfigurationElement[] configs;
        IConfigurationElement[] iConfigurationElementArray = configs = extension.getConfigurationElements();
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                this.instanciateAndRegister(tracker, extension, element);
            }
            catch (CoreException e) {
                SonarLintLogger.get().error("Unable to load one SonarLint extension", e);
            }
            ++n2;
        }
    }

    private void instanciateAndRegister(IExtensionTracker tracker, IExtension extension, IConfigurationElement element) throws CoreException {
        for (SonarLintEP<?> ep : this.allEps) {
            if (!((SonarLintEP)ep).id.equals(extension.getExtensionPointUniqueIdentifier())) continue;
            Object instance = element.createExecutableExtension(ATTR_CLASS);
            ((SonarLintEP)ep).instances.add(instance);
            tracker.registerObject(extension, instance, 2);
            break;
        }
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        for (SonarLintEP<?> ep : this.allEps) {
            if (!((SonarLintEP)ep).id.equals(extension.getExtensionPointUniqueIdentifier())) continue;
            ((SonarLintEP)ep).instances.removeAll(Arrays.asList(objects));
            break;
        }
    }

    public Collection<ProjectConfigurator> getConfigurators() {
        return ((SonarLintEP)this.configuratorEp).instances;
    }

    public Collection<IAnalysisConfigurator> getAnalysisConfigurators() {
        return ((SonarLintEP)this.analysisEp).instances;
    }

    public Collection<ISonarLintProjectsProvider> getProjectsProviders() {
        return ((SonarLintEP)this.projectsProviderEp).instances;
    }

    public Collection<ISonarLintProjectAdapterParticipant> getProjectAdapterParticipants() {
        return ((SonarLintEP)this.projectAdapterParticipantEp).instances;
    }

    public Collection<ISonarLintFileAdapterParticipant> getFileAdapterParticipants() {
        return ((SonarLintEP)this.fileAdapterParticipantEp).instances;
    }

    public Collection<IFileLanguageProvider> getLanguageProviders() {
        return ((SonarLintEP)this.languageEp).instances;
    }

    private static class SonarLintEP<G> {
        private final String id;
        private final Collection<G> instances = new ArrayList<G>();

        public SonarLintEP(String id) {
            this.id = id;
        }
    }
}

