/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProjectConfiguration;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProperty;
import org.sonarlint.eclipse.core.internal.utils.StringUtils;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;

public class PreferencesUtils {
    public static final String PREF_MARKER_SEVERITY = "markerSeverity";
    public static final int PREF_MARKER_SEVERITY_DEFAULT = 0;
    public static final String PREF_EXTRA_ARGS = "extraArgs";
    public static final String PREF_EXTRA_ARGS_DEFAULT = "";
    public static final String PREF_TEST_FILE_REGEXPS = "testFileRegexps";
    public static final String PREF_TEST_FILE_REGEXPS_DEFAULT = "**/*Test.*,**/test/**/*";

    private PreferencesUtils() {
    }

    public static String getTestFileRegexps() {
        return Platform.getPreferencesService().getString("org.sonarlint.eclipse.ui", PREF_TEST_FILE_REGEXPS, PREF_TEST_FILE_REGEXPS_DEFAULT, null);
    }

    public static int getMarkerSeverity() {
        return Platform.getPreferencesService().getInt("org.sonarlint.eclipse.ui", PREF_MARKER_SEVERITY, 0, null);
    }

    public static List<SonarLintProperty> getExtraPropertiesForLocalAnalysis(ISonarLintProject project) {
        String[] keyValuePairs;
        ArrayList<SonarLintProperty> props = new ArrayList<SonarLintProperty>();
        String globalExtraArgs = Platform.getPreferencesService().getString("org.sonarlint.eclipse.ui", PREF_EXTRA_ARGS, PREF_EXTRA_ARGS_DEFAULT, null);
        String[] stringArray = keyValuePairs = StringUtils.split(globalExtraArgs, "\r\n");
        int n = keyValuePairs.length;
        int n2 = 0;
        while (n2 < n) {
            String keyValuePair = stringArray[n2];
            String[] keyValue = StringUtils.split(keyValuePair, "=");
            props.add(new SonarLintProperty(keyValue[0], keyValue[1]));
            ++n2;
        }
        SonarLintProjectConfiguration sonarProject = SonarLintProjectConfiguration.read(project.getScopeContext());
        if (sonarProject.getExtraProperties() != null) {
            props.addAll(sonarProject.getExtraProperties());
        }
        return props;
    }
}

