/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.ui.launch;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;
import org.springsource.ide.eclipse.commons.internal.core.CorePlugin;
import org.springsource.ide.eclipse.commons.ui.launch.LaunchList;

public abstract class AbstractLaunchToolbarPulldown
implements IWorkbenchWindowPulldownDelegate,
ILaunchConfigurationListener {
    private IWorkbenchWindow window;
    private Menu menu;
    private LaunchList.Listener launchListener = new LaunchList.Listener(){

        @Override
        public void changed() {
            if (AbstractLaunchToolbarPulldown.this.action != null && AbstractLaunchToolbarPulldown.this.window != null) {
                AbstractLaunchToolbarPulldown.this.uiUpdate();
            }
        }
    };
    private LaunchList launches = this.createList().addListener(this.launchListener);
    private IAction action;
    private static final IContributionItem EMPTY_ITEM = new ActionContributionItem((IAction)new EmptyAction("No active processes"));

    public AbstractLaunchToolbarPulldown() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }

    protected abstract LaunchList createList();

    public void run(IAction action) {
        this.action = action;
        final LaunchList.Item l = this.launches.getLast();
        if (l != null) {
            Job job = new Job(this.getOperationName()){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        AbstractLaunchToolbarPulldown.this.performOperation(l);
                        return Status.OK_STATUS;
                    }
                    catch (Exception e) {
                        return ExceptionUtil.status((Throwable)e);
                    }
                }
            };
            job.schedule();
        } else {
            MessageDialog.openError((Shell)this.window.getShell(), (String)"No Processes Found", (String)("Couldn't " + this.getOperationName() + ": no active processes"));
        }
    }

    protected abstract String getOperationName();

    protected abstract void performOperation(LaunchList.Item var1) throws DebugException;

    public void selectionChanged(IAction action, ISelection selection) {
        this.action = action;
        this.update();
    }

    private void update() {
        if (this.action != null) {
            LaunchList.Item launch = this.launches.getLast();
            String label = this.getOperationName();
            if (launch != null) {
                label = String.valueOf(label) + " " + launch.getName();
            }
            this.action.setText(label);
            this.action.setToolTipText(label);
            this.action.setEnabled(launch != null);
        }
    }

    private void uiUpdate() {
        Display display;
        Shell shell = this.window.getShell();
        if (shell != null && (display = shell.getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractLaunchToolbarPulldown.this.update();
                }
            });
        }
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
        if (this.launches != null && this.launchListener != null) {
            this.launches.removeListener(this.launchListener);
            this.launches = null;
        }
        DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
        this.update();
    }

    public Menu getMenu(Control parent) {
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = new Menu(parent);
        this.fillMenu();
        return this.menu;
    }

    private void fillMenu() {
        new SubMenuProvider(this.launches).fill(this.menu, -1);
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        this.uiUpdate();
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        this.uiUpdate();
    }

    private static class EmptyAction
    extends Action {
        public EmptyAction(String label) {
            super(label);
        }

        public boolean isEnabled() {
            return false;
        }
    }

    private class SubMenuProvider
    extends CompoundContributionItem {
        private final LaunchList launches;

        public SubMenuProvider(LaunchList launches) {
            this.launches = launches;
        }

        protected IContributionItem[] getContributionItems() {
            return this.createContributionItems();
        }

        private IContributionItem[] createContributionItems() {
            ArrayList<Object> items = new ArrayList<Object>();
            for (LaunchList.Item launch : this.launches.getLaunches()) {
                items.add(new ActionContributionItem((IAction)new RelaunchAction(launch)));
            }
            if (items.isEmpty()) {
                items.add(EMPTY_ITEM);
            }
            IContributionItem[] array = new IContributionItem[items.size()];
            int i = 0;
            while (i < array.length) {
                array[array.length - i - 1] = (IContributionItem)items.get(i);
                ++i;
            }
            return array;
        }

        private class RelaunchAction
        extends Action {
            private final LaunchList.Item launch;

            public RelaunchAction(LaunchList.Item launch) {
                this.launch = launch;
                this.setText(launch.getName());
            }

            public void run() {
                try {
                    AbstractLaunchToolbarPulldown.this.performOperation(this.launch);
                }
                catch (DebugException e) {
                    CorePlugin.log((Throwable)e);
                }
            }
        }
    }
}

