/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.springsource.ide.eclipse.commons.ui.ICoreRunnable;

public class UiUtil {
    private static FormColors formColors;
    public static final int WEB_BROWSER_EXTERNAL = 1;

    public static void busyCursorWhile(final ICoreRunnable coreRunner) throws OperationCanceledException, CoreException {
        try {
            IRunnableWithProgress runner = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            coreRunner.run(monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runner);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                throw (CoreException)e.getCause();
            }
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.ui", "Unexpected exception", (Throwable)e));
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException();
        }
    }

    public static FormColors getFormColors(Display display) {
        if (formColors == null) {
            formColors = new FormColors(display);
            formColors.markShared();
        }
        return formColors;
    }

    public static Shell getShell() {
        return Display.getDefault().getActiveShell();
    }

    public static IViewPart getViewFromActivePerspective(String id) {
        IWorkbenchPage activePage;
        if (PlatformUI.isWorkbenchRunning() && (activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
            return activePage.findView(id);
        }
        return null;
    }

    public static void openUrl(final String location) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                UiUtil.uiThreadOpenUrl(location, WebBrowserPreference.getBrowserChoice());
            }
        });
    }

    private static void uiThreadOpenUrl(String location, int browserChoice) {
        try {
            URL url = null;
            if (location != null) {
                url = new URL(location);
            }
            if (browserChoice == 1) {
                try {
                    IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                    support.getExternalBrowser().openURL(url);
                }
                catch (Exception support) {}
            } else {
                int flags = WorkbenchBrowserSupport.getInstance().isInternalWebBrowserAvailable() ? 38 : 134;
                String generatedId = "org.eclipse.mylyn.web.browser-" + Calendar.getInstance().getTimeInMillis();
                IWebBrowser browser = WorkbenchBrowserSupport.getInstance().createBrowser(flags, generatedId, null, null);
                browser.openURL(url);
            }
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Failed to Open Browser", (String)"Browser could not be initiated");
        }
        catch (MalformedURLException e) {
            if (location == null || location.trim().equals("")) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Failed to Open Browser", (String)("No URL to open." + location));
            }
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Failed to Open Browser", (String)("Could not open URL: " + location));
        }
    }

    public static void runForked(ICoreRunnable coreRunner) throws OperationCanceledException, CoreException {
        UiUtil.runForked(coreRunner, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
    }

    public static void runForked(final ICoreRunnable coreRunner, IRunnableContext progressService) throws OperationCanceledException, CoreException {
        try {
            IRunnableWithProgress runner = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("", -1);
                    try {
                        try {
                            coreRunner.run(monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            progressService.run(true, true, runner);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                throw (CoreException)e.getCause();
            }
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.ui", "Unexpected exception", (Throwable)e));
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException();
        }
    }
}

