/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.content.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.springsource.ide.eclipse.commons.content.core.util.ContentUtil;
import org.springsource.ide.eclipse.commons.content.core.util.Descriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DescriptorReader {
    private static final String TAG_DESCRIPTORS = "descriptors";
    private static final String TAG_DESCRIPTOR = "descriptor";
    private final List<Descriptor> descriptors = new ArrayList<Descriptor>();

    public List<Descriptor> getDescriptors() {
        return Collections.unmodifiableList(this.descriptors);
    }

    private List<Descriptor> read(Document document) throws SAXException {
        Element rootNode = document.getDocumentElement();
        if (rootNode == null) {
            throw new SAXException("No root node");
        }
        ArrayList<Descriptor> newDescriptors = new ArrayList<Descriptor>(1);
        NodeList children = rootNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node childNode = children.item(i);
            if (childNode.getNodeType() == 1 && TAG_DESCRIPTOR.equals(childNode.getNodeName())) {
                Descriptor descriptor = Descriptor.read(childNode);
                newDescriptors.add(descriptor);
                this.descriptors.add(descriptor);
            }
            ++i;
        }
        return newDescriptors;
    }

    public List<Descriptor> read(File file) throws CoreException {
        try {
            return this.read(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.content.core", "Reading of descriptor failed", (Throwable)e));
        }
    }

    public List<Descriptor> read(InputStream in) throws CoreException {
        DocumentBuilder documentBuilder = ContentUtil.createDocumentBuilder();
        Document document = null;
        try {
            document = documentBuilder.parse(in);
            return this.read(document);
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.content.core", "Reading of descriptor failed", (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.content.core", "Reading of descriptor failed", (Throwable)e));
        }
    }

    public void write(File file) throws CoreException {
        DocumentBuilder documentBuilder = ContentUtil.createDocumentBuilder();
        Transformer serializer = ContentUtil.createTransformer();
        Document document = documentBuilder.newDocument();
        this.writeDocument(document);
        DOMSource source = new DOMSource(document);
        try {
            StreamResult target = new StreamResult(file);
            serializer.setOutputProperty("indent", "yes");
            serializer.transform(source, target);
        }
        catch (TransformerException e) {
            throw new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.content.core", "Could not write initialization data for tutorial"));
        }
    }

    private void writeDocument(Document document) {
        Element rootNode = document.createElement(TAG_DESCRIPTORS);
        document.appendChild(rootNode);
        for (Descriptor descriptor : this.descriptors) {
            Element childNode = document.createElement(TAG_DESCRIPTOR);
            rootNode.appendChild(childNode);
            Descriptor.write(descriptor, childNode);
        }
    }
}

