/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Scannable;
import reactor.core.publisher.FluxPeek;
import reactor.core.publisher.ParallelFlux;
import reactor.core.publisher.SignalPeek;

final class ParallelPeek<T>
extends ParallelFlux<T>
implements SignalPeek<T> {
    final ParallelFlux<T> source;
    final Consumer<? super T> onNext;
    final Consumer<? super T> onAfterNext;
    final Consumer<? super Throwable> onError;
    final Runnable onComplete;
    final Runnable onAfterTerminated;
    final Consumer<? super Subscription> onSubscribe;
    final LongConsumer onRequest;
    final Runnable onCancel;

    ParallelPeek(ParallelFlux<T> source, Consumer<? super T> onNext, Consumer<? super T> onAfterNext, Consumer<? super Throwable> onError, Runnable onComplete, Runnable onAfterTerminated, Consumer<? super Subscription> onSubscribe, LongConsumer onRequest, Runnable onCancel) {
        this.source = source;
        this.onNext = onNext;
        this.onAfterNext = onAfterNext;
        this.onError = onError;
        this.onComplete = onComplete;
        this.onAfterTerminated = onAfterTerminated;
        this.onSubscribe = onSubscribe;
        this.onRequest = onRequest;
        this.onCancel = onCancel;
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            parents[i] = new FluxPeek.PeekSubscriber<T>(subscribers[i], this);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    public long getPrefetch() {
        return this.source.getPrefetch();
    }

    @Override
    public Consumer<? super Subscription> onSubscribeCall() {
        return this.onSubscribe;
    }

    @Override
    public Consumer<? super T> onNextCall() {
        return this.onNext;
    }

    @Override
    public Consumer<? super Throwable> onErrorCall() {
        return this.onError;
    }

    @Override
    public Runnable onCompleteCall() {
        return this.onComplete;
    }

    @Override
    public Runnable onAfterTerminateCall() {
        return this.onAfterTerminated;
    }

    @Override
    public LongConsumer onRequestCall() {
        return this.onRequest;
    }

    @Override
    public Runnable onCancelCall() {
        return this.onCancel;
    }

    @Override
    public Consumer<? super T> onAfterNextCall() {
        return this.onAfterNext;
    }

    @Override
    public Object scan(Scannable.Attr key) {
        switch (key) {
            case PARENT: {
                return this.source;
            }
            case PREFETCH: {
                return this.getPrefetch();
            }
        }
        return null;
    }
}

