/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.function.Function;
import org.reactivestreams.Subscriber;
import reactor.core.Scannable;
import reactor.core.publisher.FluxMap;
import reactor.core.publisher.ParallelFlux;

final class ParallelMap<T, R>
extends ParallelFlux<R>
implements Scannable {
    final ParallelFlux<T> source;
    final Function<? super T, ? extends R> mapper;

    ParallelMap(ParallelFlux<T> source, Function<? super T, ? extends R> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    public Object scan(Scannable.Attr key) {
        switch (key) {
            case PARENT: {
                return this.source;
            }
            case PREFETCH: {
                return this.getPrefetch();
            }
        }
        return null;
    }

    @Override
    public void subscribe(Subscriber<? super R>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            parents[i] = new FluxMap.MapSubscriber<T, R>(subscribers[i], this.mapper);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }
}

