/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;

final class MonoReduceSeed<T, R>
extends MonoSource<T, R>
implements Fuseable {
    final Supplier<R> initialSupplier;
    final BiFunction<R, ? super T, R> accumulator;

    MonoReduceSeed(Flux<? extends T> source, Supplier<R> initialSupplier, BiFunction<R, ? super T, R> accumulator) {
        super(source);
        this.initialSupplier = Objects.requireNonNull(initialSupplier, "initialSupplier");
        this.accumulator = Objects.requireNonNull(accumulator, "accumulator");
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        R initialValue;
        try {
            initialValue = Objects.requireNonNull(this.initialSupplier.get(), "The initial value supplied is null");
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        this.source.subscribe(new ReduceSeedSubscriber<T, R>(s, this.accumulator, initialValue));
    }

    static final class ReduceSeedSubscriber<T, R>
    extends Operators.MonoSubscriber<T, R> {
        final BiFunction<R, ? super T, R> accumulator;
        Subscription s;
        boolean done;

        ReduceSeedSubscriber(Subscriber<? super R> actual, BiFunction<R, ? super T, R> accumulator, R value) {
            super(actual);
            this.accumulator = accumulator;
            this.value = value;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case TERMINATED: {
                    return this.done;
                }
                case PARENT: {
                    return this.s;
                }
            }
            return super.scan(key);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }

        @Override
        public void setValue(R value) {
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            R v;
            try {
                v = Objects.requireNonNull(this.accumulator.apply(this.value, t), "The accumulator returned a null value");
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this, e, t));
                return;
            }
            this.value = v;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.complete(this.value);
        }
    }
}

