/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxPeekFuseable;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.core.publisher.SignalPeek;

final class FluxPeek<T>
extends FluxSource<T, T>
implements SignalPeek<T> {
    final Consumer<? super Subscription> onSubscribeCall;
    final Consumer<? super T> onNextCall;
    final Consumer<? super Throwable> onErrorCall;
    final Runnable onCompleteCall;
    final Runnable onAfterTerminateCall;
    final LongConsumer onRequestCall;
    final Runnable onCancelCall;

    FluxPeek(Flux<? extends T> source, Consumer<? super Subscription> onSubscribeCall, Consumer<? super T> onNextCall, Consumer<? super Throwable> onErrorCall, Runnable onCompleteCall, Runnable onAfterTerminateCall, LongConsumer onRequestCall, Runnable onCancelCall) {
        super(source);
        this.onSubscribeCall = onSubscribeCall;
        this.onNextCall = onNextCall;
        this.onErrorCall = onErrorCall;
        this.onCompleteCall = onCompleteCall;
        this.onAfterTerminateCall = onAfterTerminateCall;
        this.onRequestCall = onRequestCall;
        this.onCancelCall = onCancelCall;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        if (s instanceof Fuseable.ConditionalSubscriber) {
            Fuseable.ConditionalSubscriber s2 = (Fuseable.ConditionalSubscriber)s;
            this.source.subscribe(new FluxPeekFuseable.PeekConditionalSubscriber(s2, this));
            return;
        }
        this.source.subscribe(new PeekSubscriber<T>(s, this));
    }

    @Override
    public Consumer<? super Subscription> onSubscribeCall() {
        return this.onSubscribeCall;
    }

    @Override
    public Consumer<? super T> onNextCall() {
        return this.onNextCall;
    }

    @Override
    public Consumer<? super Throwable> onErrorCall() {
        return this.onErrorCall;
    }

    @Override
    public Runnable onCompleteCall() {
        return this.onCompleteCall;
    }

    @Override
    public Runnable onAfterTerminateCall() {
        return this.onAfterTerminateCall;
    }

    @Override
    public LongConsumer onRequestCall() {
        return this.onRequestCall;
    }

    @Override
    public Runnable onCancelCall() {
        return this.onCancelCall;
    }

    static <T> void afterCompleteWithFailure(SignalPeek<T> parent, Throwable callbackFailure) {
        Exceptions.throwIfFatal(callbackFailure);
        Throwable e = Operators.onOperatorError(callbackFailure);
        try {
            if (parent.onErrorCall() != null) {
                parent.onErrorCall().accept(e);
            }
            Operators.onErrorDropped(e);
        }
        catch (Throwable t) {
            t = Exceptions.unwrap(t);
            if (e != t) {
                t.addSuppressed(e);
            }
            Operators.onErrorDropped(t);
        }
    }

    static <T> void afterErrorWithFailure(SignalPeek<T> parent, Throwable callbackFailure, Throwable originalError) {
        Exceptions.throwIfFatal(callbackFailure);
        Throwable _e = Operators.onOperatorError(null, callbackFailure, originalError);
        try {
            if (parent.onErrorCall() != null) {
                parent.onErrorCall().accept(_e);
            }
            Operators.onErrorDropped(_e);
        }
        catch (Throwable t) {
            t = Exceptions.unwrap(t);
            if (_e != t) {
                t.addSuppressed(_e);
            }
            if (originalError != t) {
                t.addSuppressed(originalError);
            }
            Operators.onErrorDropped(t);
        }
    }

    static final class PeekSubscriber<T>
    implements InnerOperator<T, T> {
        final Subscriber<? super T> actual;
        final SignalPeek<T> parent;
        Subscription s;
        boolean done;

        PeekSubscriber(Subscriber<? super T> actual, SignalPeek<T> parent) {
            this.actual = actual;
            this.parent = parent;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case TERMINATED: {
                    return this.done;
                }
            }
            return InnerOperator.super.scan(key);
        }

        public void request(long n) {
            if (this.parent.onRequestCall() != null) {
                try {
                    this.parent.onRequestCall().accept(n);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e));
                    return;
                }
            }
            this.s.request(n);
        }

        public void cancel() {
            if (this.parent.onCancelCall() != null) {
                try {
                    this.parent.onCancelCall().run();
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e));
                    return;
                }
            }
            this.s.cancel();
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                if (this.parent.onSubscribeCall() != null) {
                    try {
                        this.parent.onSubscribeCall().accept(s);
                    }
                    catch (Throwable e) {
                        Operators.error(this.actual, Operators.onOperatorError(s, e));
                        return;
                    }
                }
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            if (this.parent.onNextCall() != null) {
                try {
                    this.parent.onNextCall().accept(t);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                    return;
                }
            }
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            block9: {
                if (this.done) {
                    Operators.onErrorDropped(t);
                    return;
                }
                this.done = true;
                if (this.parent.onErrorCall() != null) {
                    try {
                        this.parent.onErrorCall().accept(t);
                    }
                    catch (Throwable e) {
                        t = Operators.onOperatorError(null, e, t);
                    }
                }
                try {
                    this.actual.onError(t);
                }
                catch (UnsupportedOperationException use) {
                    if (this.parent.onErrorCall() != null && (Exceptions.isErrorCallbackNotImplemented(use) || use.getCause() == t)) break block9;
                    throw use;
                }
            }
            if (this.parent.onAfterTerminateCall() != null) {
                try {
                    this.parent.onAfterTerminateCall().run();
                }
                catch (Throwable e) {
                    FluxPeek.afterErrorWithFailure(this.parent, e, t);
                }
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            if (this.parent.onCompleteCall() != null) {
                try {
                    this.parent.onCompleteCall().run();
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e));
                    return;
                }
            }
            this.done = true;
            this.actual.onComplete();
            if (this.parent.onAfterTerminateCall() != null) {
                try {
                    this.parent.onAfterTerminateCall().run();
                }
                catch (Throwable e) {
                    FluxPeek.afterCompleteWithFailure(this.parent, e);
                }
            }
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }
    }
}

