/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.InnerProducer;
import reactor.core.publisher.Operators;

final class FluxError<T>
extends Flux<T> {
    final Throwable error;
    final boolean whenRequested;

    FluxError(Throwable error, boolean whenRequested) {
        this.error = Objects.requireNonNull(error);
        this.whenRequested = whenRequested;
    }

    public void subscribe(Subscriber<? super T> s) {
        if (this.whenRequested) {
            s.onSubscribe((Subscription)new ErrorSubscription(s, this.error));
        } else {
            Operators.error(s, Operators.onOperatorError(this.error));
        }
    }

    static final class ErrorSubscription
    implements InnerProducer {
        final Subscriber<?> actual;
        final Throwable error;
        volatile int once;
        static final AtomicIntegerFieldUpdater<ErrorSubscription> ONCE = AtomicIntegerFieldUpdater.newUpdater(ErrorSubscription.class, "once");

        ErrorSubscription(Subscriber<?> actual, Throwable error) {
            this.actual = actual;
            this.error = error;
        }

        public void request(long n) {
            if (Operators.validate(n) && ONCE.compareAndSet(this, 0, 1)) {
                this.actual.onError(this.error);
            }
        }

        public void cancel() {
            this.once = 1;
        }

        public Subscriber<?> actual() {
            return this.actual;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case ERROR: {
                    return this.error;
                }
                case CANCELLED: 
                case TERMINATED: {
                    return this.once == 1;
                }
            }
            return InnerProducer.super.scan(key);
        }
    }
}

