/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Cancellation;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;

abstract class FluxBatch<T, V>
extends FluxSource<T, V> {
    final int batchSize;
    final long timespan;
    final Scheduler timer;

    FluxBatch(Flux<T> source, int batchSize, long timespan, Scheduler timer) {
        super(source);
        if (timespan <= 0L) {
            throw new IllegalArgumentException("Timeout period must be strictly positive");
        }
        if (batchSize <= 0) {
            throw new IllegalArgumentException("BatchSize period must be strictly positive");
        }
        this.timer = Objects.requireNonNull(timer, "Timer");
        this.timespan = timespan;
        this.batchSize = batchSize;
    }

    final Subscriber<? super V> prepareSub(Subscriber<? super V> actual) {
        return Operators.serialize(actual);
    }

    static abstract class BatchSubscriber<T, V>
    implements InnerOperator<T, V> {
        final Subscriber<? super V> actual;
        static final int NOT_TERMINATED = 0;
        static final int TERMINATED_WITH_SUCCESS = 1;
        static final int TERMINATED_WITH_ERROR = 2;
        static final int TERMINATED_WITH_CANCEL = 3;
        final boolean first;
        final int batchSize;
        final long timespan;
        final Scheduler.Worker timer;
        final Runnable flushTask;
        protected Subscription subscription;
        volatile int terminated = 0;
        static final AtomicIntegerFieldUpdater<BatchSubscriber> TERMINATED = AtomicIntegerFieldUpdater.newUpdater(BatchSubscriber.class, "terminated");
        volatile long requested;
        static final AtomicLongFieldUpdater<BatchSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(BatchSubscriber.class, "requested");
        volatile int index = 0;
        static final AtomicIntegerFieldUpdater<BatchSubscriber> INDEX = AtomicIntegerFieldUpdater.newUpdater(BatchSubscriber.class, "index");
        volatile Cancellation timespanRegistration;

        BatchSubscriber(Subscriber<? super V> actual, int batchSize, boolean first, long timespan, Scheduler.Worker timer) {
            this.actual = actual;
            this.timespan = timespan;
            this.timer = timer;
            this.flushTask = () -> {
                if (this.terminated == 0) {
                    int index;
                    do {
                        if ((index = this.index) != 0) continue;
                        return;
                    } while (!INDEX.compareAndSet(this, index, 0));
                    this.flushCallback(null);
                }
            };
            this.first = first;
            this.batchSize = batchSize;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.subscription;
                }
                case CANCELLED: {
                    return this.terminated == 3;
                }
                case TERMINATED: {
                    return this.terminated == 2 || this.terminated == 1;
                }
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.requested;
                }
                case CAPACITY: {
                    return this.batchSize;
                }
                case BUFFERED: {
                    return this.batchSize - this.index;
                }
            }
            return InnerOperator.super.scan(key);
        }

        void nextCallback(T event) {
        }

        void flushCallback(T event) {
        }

        void firstCallback(T event) {
        }

        public void onNext(T value) {
            int index;
            while (!INDEX.compareAndSet(this, (index = this.index + 1) - 1, index)) {
            }
            if (index == 1) {
                this.timespanRegistration = this.timer.schedule(this.flushTask, this.timespan, TimeUnit.MILLISECONDS);
                if (this.timespanRegistration == Scheduler.REJECTED) {
                    throw Operators.onRejectedExecution(this, null, value);
                }
                if (this.first) {
                    this.firstCallback(value);
                }
            }
            this.nextCallback(value);
            if (this.index % this.batchSize == 0) {
                this.index = 0;
                if (this.timespanRegistration != null) {
                    this.timespanRegistration.dispose();
                    this.timespanRegistration = null;
                }
                this.flushCallback(value);
            }
        }

        void checkedComplete() {
            try {
                this.flushCallback(null);
            }
            finally {
                this.actual.onComplete();
            }
        }

        final boolean isCompleted() {
            return this.terminated == 1;
        }

        final boolean isFailed() {
            return this.terminated == 2;
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                if (this.terminated != 0) {
                    return;
                }
                if (this.batchSize == Integer.MAX_VALUE || n == Long.MAX_VALUE) {
                    this.requestMore(Long.MAX_VALUE);
                } else {
                    this.requestMore(Operators.multiplyCap(n, this.batchSize));
                }
            }
        }

        final void requestMore(long n) {
            Subscription s = this.subscription;
            if (s != null) {
                s.request(n);
            }
        }

        @Override
        public Subscriber<? super V> actual() {
            return this.actual;
        }

        public void onComplete() {
            if (TERMINATED.compareAndSet(this, 0, 1)) {
                this.timer.dispose();
                this.checkedComplete();
            }
        }

        public void onError(Throwable throwable) {
            if (TERMINATED.compareAndSet(this, 0, 2)) {
                this.timer.dispose();
                this.checkedError(throwable);
            }
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.subscription, s)) {
                this.subscription = s;
                this.doOnSubscribe();
                this.actual.onSubscribe((Subscription)this);
            }
        }

        abstract void doOnSubscribe();

        void checkedError(Throwable throwable) {
            this.actual.onError(throwable);
        }

        public void cancel() {
            if (TERMINATED.compareAndSet(this, 0, 3)) {
                this.timer.dispose();
                Subscription s = this.subscription;
                if (s != null) {
                    this.subscription = null;
                    s.cancel();
                }
            }
        }

        public String toString() {
            return super.toString() + "{" + (this.timer != null ? "timed - " + this.timespan + " ms" : "") + " batchSize=" + this.index + "/" + this.batchSize + " [" + (int)((float)this.index / (float)this.batchSize * 100.0f) + "%]";
        }
    }
}

