/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.stream.Stream;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Receiver;
import reactor.core.Scannable;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.InnerProducer;
import reactor.core.publisher.Operators;

public final class DirectProcessor<T>
extends FluxProcessor<T, T>
implements Receiver {
    private static final DirectInner[] EMPTY = new DirectInner[0];
    private static final DirectInner[] TERMINATED = new DirectInner[0];
    private volatile DirectInner<T>[] subscribers = EMPTY;
    private static final AtomicReferenceFieldUpdater<DirectProcessor, DirectInner[]> SUBSCRIBERS = AtomicReferenceFieldUpdater.newUpdater(DirectProcessor.class, DirectInner[].class, "subscribers");
    Throwable error;

    public static <E> DirectProcessor<E> create() {
        return new DirectProcessor();
    }

    DirectProcessor() {
    }

    @Override
    public long getPrefetch() {
        return Integer.MAX_VALUE;
    }

    public void onSubscribe(Subscription s) {
        Objects.requireNonNull(s, "s");
        if (this.subscribers != TERMINATED) {
            s.request(Long.MAX_VALUE);
        } else {
            s.cancel();
        }
    }

    public void onNext(T t) {
        Objects.requireNonNull(t, "t");
        for (DirectInner<T> s : this.subscribers) {
            s.onNext(t);
        }
    }

    public void onError(Throwable t) {
        Objects.requireNonNull(t, "t");
        this.error = t;
        for (DirectInner s : SUBSCRIBERS.getAndSet(this, TERMINATED)) {
            s.onError(t);
        }
    }

    public void onComplete() {
        for (DirectInner s : SUBSCRIBERS.getAndSet(this, TERMINATED)) {
            s.onComplete();
        }
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        if (s == null) {
            throw Exceptions.argumentIsNullException();
        }
        DirectInner<? super T> p = new DirectInner<T>(s, this);
        s.onSubscribe(p);
        if (this.add(p)) {
            if (p.cancelled) {
                this.remove(p);
            }
        } else {
            Throwable e = this.error;
            if (e != null) {
                s.onError(e);
            } else {
                s.onComplete();
            }
        }
    }

    @Override
    public Stream<? extends Scannable> inners() {
        return Stream.of(this.subscribers);
    }

    @Override
    public boolean isTerminated() {
        return TERMINATED == this.subscribers;
    }

    @Override
    public long downstreamCount() {
        return this.subscribers.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean add(DirectInner<T> s) {
        DirectInner<T>[] a = this.subscribers;
        if (a == TERMINATED) {
            return false;
        }
        DirectProcessor directProcessor = this;
        synchronized (directProcessor) {
            a = this.subscribers;
            if (a == TERMINATED) {
                return false;
            }
            int len = a.length;
            DirectInner[] b = new DirectInner[len + 1];
            System.arraycopy(a, 0, b, 0, len);
            b[len] = s;
            this.subscribers = b;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(DirectInner<T> s) {
        DirectInner<T>[] a = this.subscribers;
        if (a == TERMINATED || a == EMPTY) {
            return;
        }
        DirectProcessor directProcessor = this;
        synchronized (directProcessor) {
            a = this.subscribers;
            if (a == TERMINATED || a == EMPTY) {
                return;
            }
            int len = a.length;
            int j = -1;
            for (int i = 0; i < len; ++i) {
                if (a[i] != s) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (len == 1) {
                this.subscribers = EMPTY;
                return;
            }
            DirectInner[] b = new DirectInner[len - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, len - j - 1);
            this.subscribers = b;
        }
    }

    @Override
    public boolean hasDownstreams() {
        DirectInner<T>[] s = this.subscribers;
        return s != EMPTY && s != TERMINATED;
    }

    public boolean hasCompleted() {
        return this.subscribers == TERMINATED && this.error == null;
    }

    public boolean hasError() {
        return this.subscribers == TERMINATED && this.error != null;
    }

    @Override
    public Throwable getError() {
        if (this.subscribers == TERMINATED) {
            return this.error;
        }
        return null;
    }

    @Override
    public Object upstream() {
        return null;
    }

    static final class DirectInner<T>
    implements InnerProducer<T> {
        final Subscriber<? super T> actual;
        final DirectProcessor<T> parent;
        volatile boolean cancelled;
        volatile long requested;
        static final AtomicLongFieldUpdater<DirectInner> REQUESTED = AtomicLongFieldUpdater.newUpdater(DirectInner.class, "requested");

        DirectInner(Subscriber<? super T> actual, DirectProcessor<T> parent) {
            this.actual = actual;
            this.parent = parent;
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.parent.remove(this);
            }
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.parent;
                }
                case CANCELLED: {
                    return this.cancelled;
                }
            }
            return InnerProducer.super.scan(key);
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        void onNext(T value) {
            if (this.requested != 0L) {
                this.actual.onNext(value);
                if (this.requested != Long.MAX_VALUE) {
                    REQUESTED.decrementAndGet(this);
                }
                return;
            }
            this.parent.remove(this);
            this.actual.onError((Throwable)Exceptions.failWithOverflow("Can't deliver value due to lack of requests"));
        }

        void onError(Throwable e) {
            this.actual.onError(e);
        }

        void onComplete() {
            this.actual.onComplete();
        }
    }
}

