/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.Operators;

final class BlockingIterable<T>
implements Iterable<T>,
Scannable {
    final Flux<? extends T> source;
    final long batchSize;
    final Supplier<Queue<T>> queueSupplier;

    BlockingIterable(Flux<? extends T> source, long batchSize, Supplier<Queue<T>> queueSupplier) {
        if (batchSize <= 0L) {
            throw new IllegalArgumentException("batchSize > 0 required but it was " + batchSize);
        }
        this.source = Objects.requireNonNull(source, "source");
        this.batchSize = batchSize;
        this.queueSupplier = Objects.requireNonNull(queueSupplier, "queueSupplier");
    }

    @Override
    public Object scan(Scannable.Attr key) {
        switch (key) {
            case PREFETCH: {
                return this.batchSize;
            }
            case PARENT: {
                return this.source;
            }
        }
        return null;
    }

    @Override
    public Iterator<T> iterator() {
        SubscriberIterator<T> it = this.createIterator();
        this.source.subscribe(it);
        return it;
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.stream().spliterator();
    }

    public Stream<T> stream() {
        SubscriberIterator<T> it = this.createIterator();
        this.source.subscribe(it);
        Spliterator<T> sp = Spliterators.spliteratorUnknownSize(it, 0);
        return (Stream)StreamSupport.stream(sp, false).onClose(it);
    }

    SubscriberIterator<T> createIterator() {
        Queue<T> q;
        try {
            q = Objects.requireNonNull(this.queueSupplier.get(), "The queueSupplier returned a null queue");
        }
        catch (Throwable e) {
            throw Exceptions.propagate(e);
        }
        return new SubscriberIterator<T>(q, this.batchSize);
    }

    static final class SubscriberIterator<T>
    implements InnerConsumer<T>,
    Iterator<T>,
    Runnable {
        final Queue<T> queue;
        final long batchSize;
        final long limit;
        final Lock lock;
        final Condition condition;
        long produced;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<SubscriberIterator, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(SubscriberIterator.class, Subscription.class, "s");
        volatile boolean done;
        Throwable error;

        SubscriberIterator(Queue<T> queue, long batchSize) {
            this.queue = queue;
            this.batchSize = batchSize;
            this.limit = batchSize - (batchSize >> 2);
            this.lock = new ReentrantLock();
            this.condition = this.lock.newCondition();
        }

        @Override
        public boolean hasNext() {
            block5: while (true) {
                boolean d = this.done;
                boolean empty = this.queue.isEmpty();
                if (d) {
                    Throwable e = this.error;
                    if (e != null) {
                        throw Exceptions.propagate(e);
                    }
                    if (empty) {
                        return false;
                    }
                }
                if (!empty) break;
                this.lock.lock();
                try {
                    while (true) {
                        if (this.done || !this.queue.isEmpty()) continue block5;
                        this.condition.await();
                    }
                }
                catch (InterruptedException ex) {
                    this.run();
                    throw Exceptions.propagate(ex);
                }
                finally {
                    this.lock.unlock();
                    continue;
                }
                break;
            }
            return true;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                T v = this.queue.poll();
                if (v == null) {
                    this.run();
                    throw new IllegalStateException("Queue empty?!");
                }
                long p = this.produced + 1L;
                if (p == this.limit) {
                    this.produced = 0L;
                    this.s.request(p);
                } else {
                    this.produced = p;
                }
                return v;
            }
            throw new NoSuchElementException();
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                s.request(this.batchSize);
            }
        }

        public void onNext(T t) {
            if (!this.queue.offer(t)) {
                Operators.terminate(S, this);
                this.onError(Operators.onOperatorError(null, Exceptions.failWithOverflow("Queue is full?!"), t));
            } else {
                this.signalConsumer();
            }
        }

        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.signalConsumer();
        }

        public void onComplete() {
            this.done = true;
            this.signalConsumer();
        }

        void signalConsumer() {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void run() {
            Operators.terminate(S, this);
            this.signalConsumer();
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case TERMINATED: {
                    return this.done;
                }
                case PARENT: {
                    return this.s;
                }
                case CANCELLED: {
                    return this.s == Operators.cancelledSubscription();
                }
                case PREFETCH: {
                    return this.batchSize;
                }
                case ERROR: {
                    return this.error;
                }
            }
            return null;
        }
    }
}

