/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.project;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansProject;
import org.springframework.ide.eclipse.beans.core.internal.project.IBeansProjectDescriptionConstants;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.core.io.xml.XMLWriter;

public class BeansProjectDescriptionWriter
implements IBeansProjectDescriptionConstants {
    public static final String DEBUG_OPTION = "org.springframework.ide.eclipse.beans.core/project/description/debug";
    public static final boolean DEBUG = SpringCore.isDebug((String)"org.springframework.ide.eclipse.beans.core/project/description/debug");

    public static void write(BeansProject project) {
        IFile file = project.getProject().getFile((IPath)new Path(".springBeans"));
        if (DEBUG) {
            System.out.println("Writing project description to " + file.getLocation().toString());
        }
        try {
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                XMLWriter writer = new XMLWriter((OutputStream)os);
                BeansProjectDescriptionWriter.write(project, writer);
                writer.flush();
                writer.close();
            }
            if (!file.exists()) {
                file.create((InputStream)new ByteArrayInputStream(os.toByteArray()), 1, null);
            } else if (SpringCoreUtils.validateEdit((IFile[])new IFile[]{file})) {
                file.setContents((InputStream)new ByteArrayInputStream(os.toByteArray()), 1, null);
            }
        }
        catch (IOException e) {
            BeansCorePlugin.log("Error writing " + file.getFullPath(), e);
        }
        catch (CoreException e) {
            BeansCorePlugin.log(e.getStatus());
        }
    }

    public static void write(BeansProject project, XMLWriter writer) {
        writer.startTag("beansProjectDescription", null);
        writer.printSimpleTag("version", (Object)"1");
        writer.printCDataTag("pluginVersion", (Object)BeansCorePlugin.getPluginVersion());
        BeansProjectDescriptionWriter.writeCData("configSuffixes", "configSuffix", project.getConfigSuffixes(), writer);
        writer.printCDataTag("enableImports", (Object)project.isImportsEnabled());
        BeansProjectDescriptionWriter.write("configs", "config", project.getManualConfigNames(), writer);
        BeansProjectDescriptionWriter.write("autoconfigs", "config", project.getAutoConfigNames(), writer);
        BeansProjectDescriptionWriter.write("configSets", project.getConfigSets(), writer);
        writer.endTag("beansProjectDescription");
    }

    protected static void write(IBeansConfigSet configSet, XMLWriter writer) {
        writer.startTag("configSet", null);
        writer.printCDataTag("name", (Object)configSet.getElementName());
        writer.printSimpleTag("allowBeanDefinitionOverriding", (Object)Boolean.valueOf(configSet.isAllowBeanDefinitionOverriding()).toString());
        writer.printSimpleTag("incomplete", (Object)Boolean.valueOf(configSet.isIncomplete()).toString());
        BeansProjectDescriptionWriter.write("configs", "config", configSet.getConfigNames(), writer);
        BeansProjectDescriptionWriter.writeCData("profiles", "profile", configSet.getProfiles(), writer);
        writer.endTag("configSet");
    }

    protected static void write(String name, Set<?> elements, XMLWriter writer) {
        writer.startTag(name, null);
        for (Object element : elements) {
            if (!(element instanceof IBeansConfigSet) || ((IBeansConfigSet)element).getType() != IBeansConfigSet.Type.MANUAL) continue;
            BeansProjectDescriptionWriter.write((IBeansConfigSet)element, writer);
        }
        writer.endTag(name);
    }

    protected static void write(String name, String elementTagName, String[] values, XMLWriter writer) {
        writer.startTag(name, null);
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            writer.printSimpleTag(elementTagName, (Object)value);
            ++n2;
        }
        writer.endTag(name);
    }

    protected static void write(String name, String elementTagName, Set<?> values, XMLWriter writer) {
        writer.startTag(name, null);
        for (Object value : values) {
            writer.printSimpleTag(elementTagName, value);
        }
        writer.endTag(name);
    }

    protected static void writeCData(String name, String elementTagName, Set<?> values, XMLWriter writer) {
        writer.startTag(name, null);
        for (Object value : values) {
            writer.printCDataTag(elementTagName, value);
        }
        writer.endTag(name);
    }
}

