/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.ide.eclipse.beans.core.internal.model.AbstractBeansValueHolder;
import org.springframework.ide.eclipse.beans.core.model.IBeansMap;
import org.springframework.ide.eclipse.beans.core.model.IBeansMapEntry;
import org.springframework.ide.eclipse.beans.core.model.IBeansProperties;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.ide.eclipse.core.model.xml.XmlSourceLocation;
import org.springframework.util.ObjectUtils;

public class BeansMapEntry
extends AbstractBeansValueHolder
implements IBeansMapEntry {
    private Object key;

    public BeansMapEntry(IBeansMap map, Map.Entry<?, ?> entry) {
        super(map, "(map entry)", null, null);
        this.setLocation(entry);
    }

    public int getElementType() {
        return 15;
    }

    @Override
    public IModelElement[] getElementChildren() {
        Object value;
        ArrayList<IModelElement> children = new ArrayList<IModelElement>();
        if (!(this.getElementParent() instanceof IBeansProperties) && this.key instanceof IModelElement) {
            children.add((IModelElement)this.key);
        }
        if ((value = this.getValue()) instanceof IModelElement) {
            children.add((IModelElement)value);
        }
        return children.toArray(new IModelElement[children.size()]);
    }

    @Override
    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            if (this.key instanceof IModelElement) {
                ((IModelElement)this.key).accept(visitor, monitor);
                if (monitor.isCanceled()) {
                    return;
                }
            }
            super.accept(visitor, monitor);
        }
    }

    public void setKey(Object key) {
        this.key = key;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BeansMapEntry)) {
            return false;
        }
        BeansMapEntry that = (BeansMapEntry)other;
        if (!ObjectUtils.nullSafeEquals((Object)this.key, (Object)that.key)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object)this.key);
        return this.getElementType() * hashCode + super.hashCode();
    }

    @Override
    public String toString() {
        StringBuffer text = new StringBuffer(super.toString());
        text.append(", key=");
        text.append(this.key);
        return text.toString();
    }

    private void setLocation(Map.Entry<?, ?> entry) {
        Object source;
        Object value;
        Object source2;
        XmlSourceLocation location = null;
        Object key = entry.getKey();
        if (key instanceof BeanMetadataElement && (source2 = ((BeanMetadataElement)key).getSource()) instanceof XmlSourceLocation) {
            location = new XmlSourceLocation((XmlSourceLocation)source2);
        }
        if ((value = entry.getValue()) instanceof BeanMetadataElement && (source = ((BeanMetadataElement)value).getSource()) instanceof XmlSourceLocation) {
            if (location == null) {
                location = new XmlSourceLocation((XmlSourceLocation)source);
            } else {
                location.setEndLine(((XmlSourceLocation)source).getEndLine());
            }
        }
        if (location != null) {
            location.setLocalName("<entry");
            this.setElementSourceLocation((IModelSourceLocation)location);
        }
    }
}

