/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.IPersistableElement;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.AliasDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.parsing.DefaultsDefinition;
import org.springframework.beans.factory.parsing.EmptyReaderEventListener;
import org.springframework.beans.factory.parsing.ImportDefinition;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.parsing.ReaderEventListener;
import org.springframework.beans.factory.parsing.SourceExtractor;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.SimpleBeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionDocumentReader;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.DefaultBeanDefinitionDocumentReader;
import org.springframework.beans.factory.xml.DocumentDefaultsDefinition;
import org.springframework.beans.factory.xml.DocumentLoader;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.beans.factory.xml.PluggableSchemaResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.AbstractBeansConfig;
import org.springframework.ide.eclipse.beans.core.internal.model.BeanAlias;
import org.springframework.ide.eclipse.beans.core.internal.model.BeanRegistrationContextTracker;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansImport;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelElementToPersistableElementAdapter;
import org.springframework.ide.eclipse.beans.core.internal.model.DefaultModelElementProvider;
import org.springframework.ide.eclipse.beans.core.internal.model.DelegatingSourceExtractor;
import org.springframework.ide.eclipse.beans.core.internal.model.ImportedBeansConfig;
import org.springframework.ide.eclipse.beans.core.internal.model.ProfileAwareCompositeComponentDefinition;
import org.springframework.ide.eclipse.beans.core.internal.model.ToolingAwareEnvironment;
import org.springframework.ide.eclipse.beans.core.internal.model.UniqueBeanNameGenerator;
import org.springframework.ide.eclipse.beans.core.internal.model.namespaces.DelegatingNamespaceHandlerResolver;
import org.springframework.ide.eclipse.beans.core.internal.model.namespaces.DocumentAccessor;
import org.springframework.ide.eclipse.beans.core.internal.model.namespaces.XmlCatalogDelegatingEntityResolver;
import org.springframework.ide.eclipse.beans.core.internal.model.process.BeansConfigPostProcessorFactory;
import org.springframework.ide.eclipse.beans.core.internal.parser.BeansDtdResolver;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansComponent;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigEventListener;
import org.springframework.ide.eclipse.beans.core.model.IBeansImport;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.core.model.IReloadableBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.process.IBeansConfigPostProcessor;
import org.springframework.ide.eclipse.beans.core.namespaces.IModelElementProvider;
import org.springframework.ide.eclipse.beans.core.namespaces.NamespaceUtils;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.core.io.EclipsePathMatchingResourcePatternResolver;
import org.springframework.ide.eclipse.core.io.ExternalFile;
import org.springframework.ide.eclipse.core.io.FileResource;
import org.springframework.ide.eclipse.core.io.StorageResource;
import org.springframework.ide.eclipse.core.io.ZipEntryStorage;
import org.springframework.ide.eclipse.core.io.xml.LineNumberPreservingDOMParser;
import org.springframework.ide.eclipse.core.io.xml.XercesDocumentLoader;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.DefaultModelSourceLocation;
import org.springframework.ide.eclipse.core.model.ILazyInitializedModelElement;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblem;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.core.model.xml.XmlSourceLocation;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BeansConfig
extends AbstractBeansConfig
implements IBeansConfig,
ILazyInitializedModelElement,
IReloadableBeansConfig {
    private static final String DEBUG_OPTION = "org.springframework.ide.eclipse.beans.core/model/loading/debug";
    private static final boolean DEBUG = SpringCore.isDebug((String)"org.springframework.ide.eclipse.beans.core/model/loading/debug");
    public static final IModelElementProvider DEFAULT_ELEMENT_PROVIDER = new DefaultModelElementProvider();
    private volatile IResource currentResource = null;
    private volatile EncodedResource currentEncodedResource;
    private volatile Set<IBeansConfigPostProcessor> ownPostProcessors = new HashSet<IBeansConfigPostProcessor>();
    private volatile Set<IBeansConfigPostProcessor> removedPostProcessors = new HashSet<IBeansConfigPostProcessor>();
    private volatile Map<IBeansConfigPostProcessor, Set<IBeansConfig>> externalPostProcessors = new ConcurrentHashMap<IBeansConfigPostProcessor, Set<IBeansConfig>>();
    private volatile Resource resource;
    private volatile ProblemReporter problemReporter;
    private volatile BeanNameGenerator beanNameGenerator;
    private volatile SimpleBeanDefinitionRegistry registry;
    private transient IModelElement[] children;
    private BeanRegistrationContextTracker beanRegistrationTracker = new BeanRegistrationContextTracker();

    public BeansConfig(IBeansProject project, String name, IBeansConfig.Type type) {
        super(project, name, type);
        this.init(name, project);
    }

    public IModelElement[] getElementChildren() {
        this.readConfig();
        try {
            this.r.lock();
            IModelElement[] iModelElementArray = this.children;
            return iModelElementArray;
        }
        finally {
            this.r.unlock();
        }
    }

    public boolean isInitialized() {
        return this.isModelPopulated;
    }

    @Override
    public void reload() {
        if (this.file != null) {
            try {
                this.w.lock();
                this.isModelPopulated = false;
                this.modificationTimestamp = -1L;
                this.defaults = null;
                this.imports.clear();
                this.aliases.clear();
                this.beans.clear();
                this.components.clear();
                this.isBeanClassesMapPopulated = false;
                this.beanClassesMap.clear();
                this.problems.clear();
                this.children = null;
                this.beanRegistrationTracker.clear();
            }
            finally {
                this.w.unlock();
            }
            for (IBeansConfigEventListener eventListener : this.eventListeners) {
                eventListener.onReset(this);
            }
        }
    }

    protected void init(String name, IBeansProject project) {
        IProject container = null;
        String fileName = null;
        String fullPath = null;
        int pos = name.indexOf("!");
        if (pos != -1) {
            this.isArchived = true;
            fileName = name.substring(0, pos);
        } else {
            fileName = name;
        }
        if (fileName.startsWith("external:/")) {
            IPath resolvedPath = JavaCore.getResolvedVariablePath((IPath)new Path(fileName = fileName.substring("external:/".length())));
            if (resolvedPath != null) {
                fileName = resolvedPath.toString();
            }
            this.file = new ExternalFile(new File(fileName), name.substring(pos + 1), project.getProject());
        } else {
            container = (IProject)((IResourceModelElement)this.getElementParent()).getElementResource();
            fullPath = container.getFullPath().append(fileName).toString();
            this.file = (IFile)container.findMember(fileName);
        }
        if (this.file == null || !this.file.exists()) {
            this.modificationTimestamp = -1L;
            String msg = "Beans config file '" + fullPath + "' not accessible";
            this.problems = new CopyOnWriteArraySet();
            this.problems.add(new ValidationProblem(2, msg, (IResource)this.file, -1, new ValidationProblemAttribute[0]));
        } else {
            this.modificationTimestamp = this.file.getModificationStamp();
            try {
                this.file.setSessionProperty(IBeansConfig.CONFIG_FILE_TAG, (Object)"taggedAsPotentialConfigFile");
            }
            catch (CoreException e) {
                BeansCorePlugin.log((IStatus)new Status(2, "org.springframework.ide.eclipse.beans.core", String.format("Error occured while tagging config file '%s'", this.file.getFullPath()), (Throwable)e));
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    protected void readConfig() {
        if (!this.isModelPopulated) {
            block32: {
                block33: {
                    start = System.currentTimeMillis();
                    count = 0L;
                    this.w.lock();
                    if (this.isModelPopulated) {
                        this.w.unlock();
                        return;
                    }
                    projectIncludingClassloader = this.getProjectRelatedClassLoader();
                    try {
                        for (IBeansConfigEventListener eventListener : this.eventListeners) {
                            eventListener.onReadStart(this);
                        }
                        if (this.file == null || !this.file.exists()) break block32;
                        resourceLoader /* !! */  = this.getElementParent() instanceof IBeansProject != false && ((IBeansProject)this.getElementParent()).isImportsEnabled() != false ? new EclipsePathMatchingResourcePatternResolver(this.file.getProject(), projectIncludingClassloader) : new ClassResourceFilteringPatternResolver(this.file.getProject(), projectIncludingClassloader);
                        this.modificationTimestamp = this.file.getModificationStamp();
                        this.resource = this.isArchived ? (this.file instanceof Resource ? (Resource)this.file : new StorageResource(new ZipEntryStorage(this.file.getProject(), this.getElementName()), this.file.getProject())) : new FileResource(this.file);
                        namespaceResolvingClassloader = projectIncludingClassloader;
                        if (!NamespaceUtils.useNamespacesFromClasspath(this.file.getProject())) {
                            namespaceResolvingClassloader = BeansCorePlugin.getClassLoader();
                        }
                        this.registry = new ScannedGenericBeanDefinitionSuppressingBeanDefinitionRegistry();
                        resolver = new XmlCatalogDelegatingEntityResolver(new BeansDtdResolver(), (EntityResolver)new PluggableSchemaResolver(namespaceResolvingClassloader));
                        documentAccessor = new DocumentAccessor();
                        sourceExtractor = new DelegatingSourceExtractor(this.file.getProject());
                        eventListener = new BeansConfigReaderEventListener(this, this.resource, sourceExtractor, documentAccessor);
                        namespaceHandlerResolver = new DelegatingNamespaceHandlerResolver(namespaceResolvingClassloader, this, documentAccessor);
                        this.problemReporter = new BeansConfigProblemReporter();
                        this.beanNameGenerator = new UniqueBeanNameGenerator(this);
                        reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this.registry, (NamespaceHandlerResolver)namespaceHandlerResolver){
                            private final /* synthetic */ NamespaceHandlerResolver val$namespaceHandlerResolver;
                            {
                                this.val$namespaceHandlerResolver = namespaceHandlerResolver;
                                super($anonymous0);
                            }

                            public int loadBeanDefinitions(EncodedResource encodedResource) throws BeanDefinitionStoreException {
                                if (encodedResource != null && encodedResource.getResource() instanceof IAdaptable) {
                                    BeansConfig.this.currentResource = (IResource)((IAdaptable)encodedResource.getResource()).getAdapter(IResource.class);
                                    BeansConfig.this.currentEncodedResource = encodedResource;
                                }
                                try {
                                    int loadedBeans = 0;
                                    if (encodedResource.getResource().exists()) {
                                        loadedBeans = super.loadBeanDefinitions(encodedResource);
                                    }
                                    int n = loadedBeans;
                                    return n;
                                }
                                finally {
                                    BeansConfig.this.currentResource = null;
                                    BeansConfig.this.currentEncodedResource = null;
                                }
                            }

                            public int registerBeanDefinitions(Document doc, Resource resource) throws BeanDefinitionStoreException {
                                try {
                                    documentAccessor.pushDocument(doc);
                                    int n = super.registerBeanDefinitions(doc, resource);
                                    return n;
                                }
                                finally {
                                    documentAccessor.popDocument();
                                }
                            }

                            public XmlReaderContext createReaderContext(Resource resource) {
                                return new ProfileAwareReaderContext(resource, BeansConfig.this.problemReporter, eventListener, sourceExtractor, this, this.val$namespaceHandlerResolver);
                            }

                            protected BeanDefinitionDocumentReader createBeanDefinitionDocumentReader() {
                                return new ToolingFriendlyBeanDefinitionDocumentReader(BeansConfig.this);
                            }
                        };
                        reader.setDocumentLoader((DocumentLoader)new XercesDocumentLoader());
                        reader.setResourceLoader((ResourceLoader)resourceLoader /* !! */ );
                        reader.setEntityResolver((EntityResolver)resolver);
                        reader.setSourceExtractor((SourceExtractor)sourceExtractor);
                        reader.setEventListener((ReaderEventListener)eventListener);
                        reader.setProblemReporter(this.problemReporter);
                        reader.setErrorHandler((ErrorHandler)new BeansConfigErrorHandler());
                        reader.setNamespaceHandlerResolver((NamespaceHandlerResolver)namespaceHandlerResolver);
                        reader.setBeanNameGenerator(this.beanNameGenerator);
                        reader.setEnvironment((Environment)new ToolingAwareEnvironment());
                        throwables = new HashMap<K, V>();
                        try {
                            loadBeanDefinitionOperation = new Callable<Integer>((ResourceLoader)resourceLoader /* !! */ , reader, eventListener, throwables, documentAccessor){
                                private final /* synthetic */ ResourceLoader val$resourceLoader;
                                private final /* synthetic */ XmlBeanDefinitionReader val$reader;
                                private final /* synthetic */ BeansConfigReaderEventListener val$eventListener;
                                private final /* synthetic */ Map val$throwables;
                                private final /* synthetic */ DocumentAccessor val$documentAccessor;
                                {
                                    this.val$resourceLoader = resourceLoader;
                                    this.val$reader = xmlBeanDefinitionReader;
                                    this.val$eventListener = beansConfigReaderEventListener;
                                    this.val$throwables = map;
                                    this.val$documentAccessor = documentAccessor;
                                }

                                @Override
                                public Integer call() {
                                    ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
                                    Thread.currentThread().setContextClassLoader(this.val$resourceLoader.getClassLoader());
                                    try {
                                        int count = this.val$reader.loadBeanDefinitions(BeansConfig.this.resource);
                                        this.val$eventListener.registerComponents();
                                        BeansConfig.this.postProcess(this.val$resourceLoader.getClassLoader());
                                        Integer n = count;
                                        return n;
                                    }
                                    catch (Exception e) {
                                        this.val$throwables.put(e, LineNumberPreservingDOMParser.getStartLineNumber((Node)this.val$documentAccessor.getLastElement()));
                                    }
                                    finally {
                                        Thread.currentThread().setContextClassLoader(threadClassLoader);
                                    }
                                    return 0;
                                }
                            };
                            try {
                                task = new FutureTask<Integer>(loadBeanDefinitionOperation);
                                BeansCorePlugin.getExecutorService().submit(task);
                                count = task.get(BeansCorePlugin.getDefault().getPreferenceStore().getInt("org.springframework.ide.eclipse.beans.core.timeoutConfigLoading"), TimeUnit.SECONDS).intValue();
                                if (throwables.size() > 0) {
                                    throw (Throwable)throwables.keySet().iterator().next();
                                }
                                break block32;
                            }
                            catch (TimeoutException v0) {
                                this.problems.add(new ValidationProblem(2, "Loading of resource '" + this.resource.getFile().getAbsolutePath() + "' took more than " + BeansCorePlugin.getDefault().getPreferenceStore().getInt("org.springframework.ide.eclipse.beans.core.timeoutConfigLoading") + "sec", (IResource)this.file, 1, new ValidationProblemAttribute[0]));
                            }
                        }
                        catch (Throwable e) {
                            line = -1;
                            if (throwables.containsKey(e)) {
                                line = (Integer)throwables.get(e);
                            }
                            if (e instanceof BeanDefinitionStoreException) {
                                if (e.getCause() != null) {
                                    this.problems.add(new ValidationProblem(2, String.format("Error occured processing XML '%s'. See Error Log for more details", new Object[]{e.getCause().getMessage()}), (IResource)this.file, line, new ValidationProblemAttribute[0]));
                                    BeansCorePlugin.log((IStatus)new Status(1, "org.springframework.ide.eclipse.beans.core", String.format("Error occured processing '%s'", new Object[]{this.file.getFullPath()}), e.getCause()));
                                } else {
                                    this.problems.add(new ValidationProblem(2, e.getMessage(), (IResource)this.file, line, new ValidationProblemAttribute[0]));
                                    BeansCorePlugin.log((IStatus)new Status(1, "org.springframework.ide.eclipse.beans.core", String.format("Error occured processing '%s'", new Object[]{this.file.getFullPath()}), e));
                                }
                            } else if (!(e.getCause() instanceof SAXParseException) && !(e instanceof BeanDefinitionParsingException)) {
                                this.problems.add(new ValidationProblem(2, e.getMessage(), (IResource)this.file, line, new ValidationProblemAttribute[0]));
                                BeansCorePlugin.log((IStatus)new Status(1, "org.springframework.ide.eclipse.beans.core", String.format("Error occured processing '%s'", new Object[]{this.file.getFullPath()}), e));
                            }
                            break block32;
                        }
                    }
                    catch (Throwable var17_17) {
                        allChildren = new ArrayList<V>(this.imports);
                        allChildren.addAll(this.aliases.values());
                        allChildren.addAll(this.components);
                        allChildren.addAll(this.beans.values());
                        Collections.sort(allChildren, new Comparator<ISourceModelElement>(){

                            @Override
                            public int compare(ISourceModelElement element1, ISourceModelElement element2) {
                                return element1.getElementStartLine() - element2.getElementStartLine();
                            }
                        });
                        this.children = allChildren.toArray(new IModelElement[allChildren.size()]);
                        this.isModelPopulated = true;
                        this.w.unlock();
                        this.postProcessExternal(this.externalPostProcessors.keySet(), projectIncludingClassloader);
                        if (this.ownPostProcessors == null) break block33;
                        ** for (postProcessor : this.ownPostProcessors)
                    }
lbl-1000:
                    // 2 sources

                    {
                        for (IBeansConfigEventListener eventListener : this.eventListeners) {
                            eventListener.onPostProcessorDetected(this, postProcessor);
                        }
                        continue;
                    }
                }
                if (this.removedPostProcessors != null) {
                    for (IBeansConfigPostProcessor postProcessor : this.removedPostProcessors) {
                        for (IBeansConfigEventListener eventListener : this.eventListeners) {
                            eventListener.onPostProcessorRemoved(this, postProcessor);
                        }
                    }
                }
                for (IBeansConfigEventListener eventListener : this.eventListeners) {
                    eventListener.onReadEnd(this);
                }
                if (BeansConfig.DEBUG) {
                    System.out.println(String.format("> loading of %s beans from %s took %sms", new Object[]{count, this.file.getFullPath().toString(), System.currentTimeMillis() - start}));
                }
                throw var17_17;
            }
            allChildren = new ArrayList<V>(this.imports);
            allChildren.addAll(this.aliases.values());
            allChildren.addAll(this.components);
            allChildren.addAll(this.beans.values());
            Collections.sort(allChildren, new /* invalid duplicate definition of identical inner class */);
            this.children = allChildren.toArray(new IModelElement[allChildren.size()]);
            this.isModelPopulated = true;
            this.w.unlock();
            this.postProcessExternal(this.externalPostProcessors.keySet(), projectIncludingClassloader);
            if (this.ownPostProcessors != null) {
                for (IBeansConfigPostProcessor postProcessor : this.ownPostProcessors) {
                    for (IBeansConfigEventListener eventListener : this.eventListeners) {
                        eventListener.onPostProcessorDetected(this, postProcessor);
                    }
                }
            }
            if (this.removedPostProcessors != null) {
                for (IBeansConfigPostProcessor postProcessor : this.removedPostProcessors) {
                    for (IBeansConfigEventListener eventListener : this.eventListeners) {
                        eventListener.onPostProcessorRemoved(this, postProcessor);
                    }
                }
            }
            for (IBeansConfigEventListener eventListener : this.eventListeners) {
                eventListener.onReadEnd(this);
            }
            if (BeansConfig.DEBUG) {
                System.out.println(String.format("> loading of %s beans from %s took %sms", new Object[]{count, this.file.getFullPath().toString(), System.currentTimeMillis() - start}));
            }
        }
    }

    public ClassLoader getProjectRelatedClassLoader() {
        if (this.file != null && this.file.exists()) {
            return JdtUtils.getClassLoader((IProject)this.file.getProject(), (ClassLoader)BeansCorePlugin.getClassLoader());
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPersistableElement.class) {
            return new BeansModelElementToPersistableElementAdapter(this);
        }
        if (adapter == IResource.class) {
            return this.getElementResource();
        }
        if (adapter == Resource.class) {
            return this.resource;
        }
        return super.getAdapter(adapter);
    }

    private void postProcess(ClassLoader classloader) {
        LinkedHashSet<IBeansConfigPostProcessor> detectedPostProcessors = new LinkedHashSet<IBeansConfigPostProcessor>();
        this.removedPostProcessors = new LinkedHashSet<IBeansConfigPostProcessor>();
        BeansConfigPostProcessorReaderEventListener eventListener = new BeansConfigPostProcessorReaderEventListener();
        ArrayList<IBean> beansClone = new ArrayList<IBean>();
        beansClone.addAll(this.beans.values());
        for (IBeansComponent iBeansComponent : this.components) {
            this.addBeansFromCompoent(iBeansComponent, beansClone);
        }
        for (IBeansImport iBeansImport : this.imports) {
            for (IBeansConfig iBeansConfig : iBeansImport.getImportedBeansConfigs()) {
                beansClone.addAll(iBeansConfig.getBeans());
                for (IBeansComponent component : iBeansConfig.getComponents()) {
                    this.addBeansFromCompoent(component, beansClone);
                }
            }
        }
        IBeansConfigPostProcessor[] iBeansConfigPostProcessorArray = BeansConfigPostProcessorFactory.createPostProcessor(null);
        int n = iBeansConfigPostProcessorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = iBeansConfigPostProcessorArray[n2];
            this.executePostProcessor((IBeansConfigPostProcessor)object, (ReaderEventListener)eventListener, classloader);
            ++n2;
        }
        for (IBean iBean : beansClone) {
            IType type;
            String string = iBean.getClassName();
            if (string == null || (type = JdtUtils.getJavaType((IProject)this.getElementResource().getProject(), (String)string)) == null) continue;
            IBeansConfigPostProcessor[] iBeansConfigPostProcessorArray2 = BeansConfigPostProcessorFactory.createPostProcessor(string);
            int n3 = iBeansConfigPostProcessorArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IBeansConfigPostProcessor postProcessor = iBeansConfigPostProcessorArray2[n4];
                this.executePostProcessor(postProcessor, (ReaderEventListener)eventListener, classloader);
                detectedPostProcessors.add(postProcessor);
                ++n4;
            }
        }
        for (IBeansConfigPostProcessor iBeansConfigPostProcessor : this.ownPostProcessors) {
            if (detectedPostProcessors.contains(iBeansConfigPostProcessor)) continue;
            this.ownPostProcessors.remove(iBeansConfigPostProcessor);
            this.removedPostProcessors.add(iBeansConfigPostProcessor);
        }
        for (IBeansConfigPostProcessor iBeansConfigPostProcessor : detectedPostProcessors) {
            if (this.ownPostProcessors.contains(iBeansConfigPostProcessor)) continue;
            this.ownPostProcessors.add(iBeansConfigPostProcessor);
        }
    }

    private void addBeansFromCompoent(IBeansComponent component, List<IBean> beansClone) {
        beansClone.addAll(component.getBeans());
        for (IBeansComponent bc : component.getComponents()) {
            this.addBeansFromCompoent(bc, beansClone);
        }
    }

    private void postProcessExternal(Set<IBeansConfigPostProcessor> postProcessors, ClassLoader classloader) {
        if (this.isModelPopulated) {
            try {
                this.w.lock();
                BeansConfigPostProcessorReaderEventListener eventListener = new BeansConfigPostProcessorReaderEventListener();
                for (IBeansConfigPostProcessor postProcessor : postProcessors) {
                    if (this.ownPostProcessors.contains(postProcessor)) continue;
                    this.executePostProcessor(postProcessor, (ReaderEventListener)eventListener, classloader);
                }
            }
            finally {
                this.w.unlock();
            }
        }
    }

    protected void addExternalPostProcessor(IBeansConfigPostProcessor postProcessor, IBeansConfig config) {
        try {
            this.w.lock();
            if (this.externalPostProcessors.containsKey(postProcessor)) {
                this.externalPostProcessors.get(postProcessor).add(config);
            } else {
                LinkedHashSet<IBeansConfig> configs = new LinkedHashSet<IBeansConfig>();
                configs.add(config);
                this.externalPostProcessors.put(postProcessor, configs);
                if (!this.ownPostProcessors.contains(postProcessor)) {
                    HashSet<IBeansConfigPostProcessor> postProcessors = new HashSet<IBeansConfigPostProcessor>();
                    postProcessors.add(postProcessor);
                    this.postProcessExternal(postProcessors, this.getProjectRelatedClassLoader());
                }
            }
        }
        finally {
            this.w.unlock();
        }
    }

    protected void removeExternalPostProcessor(IBeansConfigPostProcessor postProcessor, IBeansConfig config) {
        try {
            this.w.lock();
            if (this.externalPostProcessors.containsKey(postProcessor) && this.externalPostProcessors.get(postProcessor).remove(config) && this.externalPostProcessors.get(postProcessor).size() == 0) {
                this.externalPostProcessors.remove(postProcessor);
            }
            this.reload();
        }
        finally {
            this.w.unlock();
        }
    }

    private void executePostProcessor(final IBeansConfigPostProcessor postProcessor, final ReaderEventListener eventListener, final ClassLoader classloader) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                BeansCorePlugin.log((IStatus)new Status(2, "org.springframework.ide.eclipse.beans.core", "Error occured while running bean post processors", exception));
            }

            public void run() throws Exception {
                ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
                if (classloader != null) {
                    Thread.currentThread().setContextClassLoader(classloader);
                }
                try {
                    try {
                        postProcessor.postProcess(BeansConfigPostProcessorFactory.createPostProcessingContext(BeansConfig.this, BeansConfig.this.beans.values(), eventListener, BeansConfig.this.problemReporter, BeansConfig.this.beanNameGenerator, (BeanDefinitionRegistry)BeansConfig.this.registry, BeansConfig.this.problems));
                    }
                    catch (Exception e) {
                        this.handleException(e);
                        Thread.currentThread().setContextClassLoader(contextLoader);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(contextLoader);
                }
            }
        });
    }

    private void registerComponentDefinition(ComponentDefinition componentDefinition, Map<String, IModelElementProvider> elementProviders) {
        ISourceModelElement element;
        String uri = NamespaceUtils.getNameSpaceURI((BeanMetadataElement)componentDefinition);
        IModelElementProvider provider = elementProviders.get(uri);
        if (provider == null) {
            provider = DEFAULT_ELEMENT_PROVIDER;
        }
        if ((element = provider.getElement(this, componentDefinition)) instanceof IBean) {
            this.beans.put(element.getElementName(), (IBean)element);
        } else if (element instanceof IBeansComponent) {
            this.components.add((IBeansComponent)element);
        }
    }

    private IResource getCurrentResource() {
        if (this.currentResource != null) {
            return this.currentResource;
        }
        return this.file;
    }

    @Override
    public BeanDefinitionRegistry getRawBeanDefinitions(CompositeComponentDefinition context) {
        return this.beanRegistrationTracker.getRegistry(context);
    }

    class BeansConfigErrorHandler
    implements ErrorHandler {
        BeansConfigErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            BeansConfig.this.problems.add(new ValidationProblem(1, e.getMessage(), BeansConfig.this.getCurrentResource(), e.getLineNumber(), new ValidationProblemAttribute[0]));
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            BeansConfig.this.problems.add(new ValidationProblem(2, e.getMessage(), BeansConfig.this.getCurrentResource(), e.getLineNumber(), new ValidationProblemAttribute[0]));
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            BeansConfig.this.problems.add(new ValidationProblem(2, e.getMessage(), BeansConfig.this.getCurrentResource(), e.getLineNumber(), new ValidationProblemAttribute[0]));
        }
    }

    class BeansConfigPostProcessorReaderEventListener
    extends EmptyReaderEventListener {
        final Map<String, IModelElementProvider> elementProviders = NamespaceUtils.getElementProviders();

        BeansConfigPostProcessorReaderEventListener() {
        }

        public void componentRegistered(ComponentDefinition componentDefinition) {
            if (componentDefinition.getSource() == null && componentDefinition instanceof BeanComponentDefinition) {
                ((AbstractBeanDefinition)((BeanComponentDefinition)componentDefinition).getBeanDefinition()).setSource((Object)new DefaultModelSourceLocation(1, 1, BeansConfig.this.resource));
            }
            BeansConfig.this.registerComponentDefinition(componentDefinition, this.elementProviders);
        }
    }

    class BeansConfigProblemReporter
    implements ProblemReporter {
        BeansConfigProblemReporter() {
        }

        public void fatal(Problem problem) {
            BeansConfig.this.problems.add(new ValidationProblem(2, this.getMessage(problem), BeansConfig.this.getCurrentResource(), this.getLine(problem), new ValidationProblemAttribute[0]));
            throw new BeanDefinitionParsingException(problem);
        }

        public void error(Problem problem) {
            BeansConfig.this.problems.add(new ValidationProblem(2, this.getMessage(problem), BeansConfig.this.getCurrentResource(), this.getLine(problem), new ValidationProblemAttribute[0]));
        }

        public void warning(Problem problem) {
            BeansConfig.this.problems.add(new ValidationProblem(1, this.getMessage(problem), BeansConfig.this.getCurrentResource(), this.getLine(problem), new ValidationProblemAttribute[0]));
        }

        private String getMessage(Problem problem) {
            StringBuffer message = new StringBuffer(problem.getMessage());
            Throwable rootCause = problem.getRootCause();
            if (rootCause != null) {
                while (rootCause.getCause() != null) {
                    rootCause = rootCause.getCause();
                }
                message.append(": ");
                message.append(rootCause.getMessage());
            }
            return message.toString();
        }

        private int getLine(Problem problem) {
            Object source = problem.getLocation().getSource();
            if (source instanceof XmlSourceLocation) {
                return ((XmlSourceLocation)source).getStartLine();
            }
            if (source instanceof Node) {
                return LineNumberPreservingDOMParser.getStartLineNumber((Node)((Node)source));
            }
            return -1;
        }
    }

    class BeansConfigReaderEventListener
    implements ReaderEventListener {
        private IBeansConfig config;
        private Resource resource;
        private Map<String, IModelElementProvider> elementProviders;
        private Map<Resource, Set<ComponentDefinition>> componentDefinitionsCache;
        private Map<Resource, Set<ImportDefinition>> importDefinitionsCache;
        private Map<Resource, Set<AliasDefinition>> aliasDefinitionsCache;
        private Map<Resource, DocumentDefaultsDefinition> defaultDefinitionsCache;
        private SourceExtractor sourceExtractor;
        private DocumentAccessor documentAccessor;

        public BeansConfigReaderEventListener(IBeansConfig config, Resource resource, SourceExtractor sourceExtractor, DocumentAccessor documentAccessor) {
            this.config = config;
            this.resource = resource;
            this.elementProviders = NamespaceUtils.getElementProviders();
            this.componentDefinitionsCache = new HashMap<Resource, Set<ComponentDefinition>>();
            this.importDefinitionsCache = new HashMap<Resource, Set<ImportDefinition>>();
            this.aliasDefinitionsCache = new HashMap<Resource, Set<AliasDefinition>>();
            this.defaultDefinitionsCache = new HashMap<Resource, DocumentDefaultsDefinition>();
            this.sourceExtractor = sourceExtractor;
            this.documentAccessor = documentAccessor;
        }

        public void defaultsRegistered(DefaultsDefinition defaultsDefinition) {
            Object source;
            if (defaultsDefinition instanceof DocumentDefaultsDefinition && (source = defaultsDefinition.getSource()) instanceof IModelSourceLocation) {
                Resource resource = ((IModelSourceLocation)source).getResource();
                this.addDefaultToCache((DocumentDefaultsDefinition)defaultsDefinition, resource);
            }
        }

        public void importProcessed(ImportDefinition importDefinition) {
            Object source = importDefinition.getSource();
            if (source instanceof IModelSourceLocation) {
                Resource resource = ((IModelSourceLocation)source).getResource();
                this.addImportToCache(importDefinition, resource);
            }
        }

        public void aliasRegistered(AliasDefinition aliasDefinition) {
            Object source = aliasDefinition.getSource();
            if (source instanceof IModelSourceLocation) {
                Resource resource = ((IModelSourceLocation)source).getResource();
                this.addAliasToCache(aliasDefinition, resource);
            }
        }

        public void componentRegistered(ComponentDefinition componentDefinition) {
            Object source = componentDefinition.getSource();
            if (source == null && BeansConfig.this.currentEncodedResource != null && BeansConfig.this.currentEncodedResource.getResource() != null) {
                source = this.sourceExtractor.extractSource((Object)this.documentAccessor.getCurrentElement(), BeansConfig.this.currentEncodedResource.getResource());
                BeanDefinition[] beanDefinitionArray = componentDefinition.getBeanDefinitions();
                int n = beanDefinitionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BeanDefinition beanDefinition = beanDefinitionArray[n2];
                    if (beanDefinition.getSource() == null && beanDefinition instanceof AbstractBeanDefinition) {
                        ((AbstractBeanDefinition)beanDefinition).setSource(source);
                        ((AbstractBeanDefinition)beanDefinition).setRole(2);
                    }
                    ++n2;
                }
            }
            this.addSourceToNestedBeanDefinitions(componentDefinition);
            if (source instanceof IModelSourceLocation) {
                Resource resource = ((IModelSourceLocation)source).getResource();
                this.addComponentToCache(componentDefinition, resource);
            }
        }

        private void addAliasToCache(AliasDefinition aliasDefinition, Resource resource) {
            if (this.aliasDefinitionsCache.containsKey(resource)) {
                this.aliasDefinitionsCache.get(resource).add(aliasDefinition);
            } else {
                LinkedHashSet<AliasDefinition> aliasDefinitions = new LinkedHashSet<AliasDefinition>();
                aliasDefinitions.add(aliasDefinition);
                this.aliasDefinitionsCache.put(resource, aliasDefinitions);
            }
        }

        private void addSourceToNestedBeanDefinitions(ComponentDefinition componentDefinition) {
            if (componentDefinition instanceof CompositeComponentDefinition) {
                CompositeComponentDefinition compositeComponentDefinition = (CompositeComponentDefinition)componentDefinition;
                ComponentDefinition[] componentDefinitionArray = compositeComponentDefinition.getNestedComponents();
                int n = componentDefinitionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ComponentDefinition nestedComponentDefinition = componentDefinitionArray[n2];
                    BeanDefinition[] beanDefinitionArray = nestedComponentDefinition.getBeanDefinitions();
                    int n3 = beanDefinitionArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        BeanDefinition beanDefinition = beanDefinitionArray[n4];
                        if (!(beanDefinition.getSource() instanceof IModelSourceLocation) && beanDefinition instanceof AbstractBeanDefinition) {
                            ((AbstractBeanDefinition)beanDefinition).setSource(this.sourceExtractor.extractSource(beanDefinition.getSource(), this.resource));
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }

        private void addComponentToCache(ComponentDefinition componentDefinition, Resource resource) {
            if (this.componentDefinitionsCache.containsKey(resource)) {
                this.componentDefinitionsCache.get(resource).add(componentDefinition);
            } else {
                LinkedHashSet<ComponentDefinition> componentDefinitions = new LinkedHashSet<ComponentDefinition>();
                componentDefinitions.add(componentDefinition);
                this.componentDefinitionsCache.put(resource, componentDefinitions);
            }
        }

        private void addDefaultToCache(DocumentDefaultsDefinition defaultsDefinition, Resource resource) {
            if (!this.defaultDefinitionsCache.containsKey(resource)) {
                this.defaultDefinitionsCache.put(resource, defaultsDefinition);
            }
        }

        private void addImportToCache(ImportDefinition importDefinition, Resource resource) {
            if (this.importDefinitionsCache.containsKey(resource)) {
                this.importDefinitionsCache.get(resource).add(importDefinition);
            } else {
                LinkedHashSet<ImportDefinition> importDefinitions = new LinkedHashSet<ImportDefinition>();
                importDefinitions.add(importDefinition);
                this.importDefinitionsCache.put(resource, importDefinitions);
            }
        }

        public void registerComponents() {
            Set<ImportDefinition> importDefinitions;
            Set<AliasDefinition> aliasDefinitions;
            BeansConfig.this.defaults = this.defaultDefinitionsCache.get(this.resource);
            Set<ComponentDefinition> componentDefinitions = this.componentDefinitionsCache.get(this.resource);
            if (componentDefinitions != null) {
                for (ComponentDefinition componentDefinition : componentDefinitions) {
                    BeansConfig.this.registerComponentDefinition(componentDefinition, this.elementProviders);
                }
            }
            if ((aliasDefinitions = this.aliasDefinitionsCache.get(this.resource)) != null) {
                for (AliasDefinition aliasDefinition : aliasDefinitions) {
                    BeansConfig.this.aliases.put(aliasDefinition.getAlias(), new BeanAlias(this.config, aliasDefinition));
                }
            }
            if ((importDefinitions = this.importDefinitionsCache.get(this.resource)) != null) {
                for (ImportDefinition importDefinition : importDefinitions) {
                    this.processImportDefinition(importDefinition, this.config);
                }
            }
        }

        private void processImportDefinition(ImportDefinition importDefinition, IBeansConfig config) {
            BeansImport beansImport = new BeansImport(config, importDefinition);
            if (config instanceof BeansConfig) {
                BeansConfig.this.imports.add(beansImport);
            } else if (config instanceof ImportedBeansConfig) {
                ((ImportedBeansConfig)config).addImport(beansImport);
            }
            if (((IBeansProject)BeansConfig.this.getElementParent()).isImportsEnabled()) {
                Resource[] importedResources;
                Resource[] resourceArray = importedResources = importDefinition.getActualResources();
                int n = importedResources.length;
                int n2 = 0;
                while (n2 < n) {
                    Set<ImportDefinition> importDefinitions;
                    Set<AliasDefinition> aliasDefinitions;
                    Resource importedResource = resourceArray[n2];
                    ImportedBeansConfig importedBeansConfig = new ImportedBeansConfig(beansImport, importedResource, BeansConfig.this.getType());
                    importedBeansConfig.readConfig();
                    beansImport.addImportedBeansConfig(importedBeansConfig);
                    importedBeansConfig.setDefaults(this.defaultDefinitionsCache.get(importedResource));
                    Set<ComponentDefinition> componentDefinitions = this.componentDefinitionsCache.get(importedResource);
                    if (componentDefinitions != null) {
                        for (ComponentDefinition componentDefinition : componentDefinitions) {
                            ISourceModelElement element;
                            String uri = NamespaceUtils.getNameSpaceURI((BeanMetadataElement)componentDefinition);
                            IModelElementProvider provider = this.elementProviders.get(uri);
                            if (provider == null) {
                                provider = DEFAULT_ELEMENT_PROVIDER;
                            }
                            if ((element = provider.getElement(importedBeansConfig, componentDefinition)) instanceof IBean) {
                                importedBeansConfig.addBean((IBean)element);
                                continue;
                            }
                            if (!(element instanceof IBeansComponent)) continue;
                            importedBeansConfig.addComponent((IBeansComponent)element);
                        }
                    }
                    if ((aliasDefinitions = this.aliasDefinitionsCache.get(importedResource)) != null) {
                        for (AliasDefinition aliasDefinition : aliasDefinitions) {
                            importedBeansConfig.addAlias(new BeanAlias(importedBeansConfig, aliasDefinition));
                        }
                    }
                    if ((importDefinitions = this.importDefinitionsCache.get(importedResource)) != null) {
                        for (ImportDefinition nestedImportDefinition : importDefinitions) {
                            this.processImportDefinition(nestedImportDefinition, importedBeansConfig);
                        }
                    }
                    importedBeansConfig.readFinish();
                    ++n2;
                }
            }
        }
    }

    class ClassResourceFilteringPatternResolver
    extends EclipsePathMatchingResourcePatternResolver
    implements ResourcePatternResolver {
        public ClassResourceFilteringPatternResolver(IProject project, ClassLoader classLoader) {
            super(project, classLoader);
        }

        public Resource getResource(String location) {
            if (location.endsWith(".class")) {
                return super.getResource(location);
            }
            return null;
        }

        public Resource[] getResources(String locationPattern) throws IOException {
            if (locationPattern.endsWith(".class")) {
                return super.getResources(locationPattern);
            }
            return new Resource[0];
        }
    }

    static class ErrorSuppressingBeanDefinitionParserDelegate
    extends BeanDefinitionParserDelegate {
        private final XmlReaderContext readerContext;

        public ErrorSuppressingBeanDefinitionParserDelegate(XmlReaderContext readerContext) {
            super(readerContext);
            this.readerContext = readerContext;
        }

        public BeanDefinition parseCustomElement(Element ele, BeanDefinition containingBd) {
            String namespaceUri = this.getNamespaceURI(ele);
            try {
                this.readerContext.getNamespaceHandlerResolver().resolve(namespaceUri);
            }
            catch (FatalBeanException e) {
                String msg = e.getMessage();
                int ix = msg.indexOf(59);
                if (ix > 0) {
                    msg = msg.substring(0, ix);
                }
                this.readerContext.warning(String.valueOf(msg) + ". Check Error Log for more details.", (Object)ele);
                BeansCorePlugin.log((IStatus)new Status(2, "org.springframework.ide.eclipse.beans.core", "Problem loading NamespaceHandler for '" + namespaceUri + "'.", (Throwable)e));
                return null;
            }
            return super.parseCustomElement(ele, containingBd);
        }
    }

    protected static class InternalScannedGenericBeanDefinition
    extends GenericBeanDefinition
    implements AnnotatedBeanDefinition {
        private static final long serialVersionUID = 467157320316462045L;
        private AnnotationMetadata metadata;
        private MethodMetadata factoryMethodMetadata;

        public InternalScannedGenericBeanDefinition(ScannedGenericBeanDefinition beanDefinition) {
            this.setBeanClassName(beanDefinition.getBeanClassName());
            this.setSource(beanDefinition.getSource());
            this.setResource(beanDefinition.getResource());
            this.metadata = beanDefinition.getMetadata();
            this.factoryMethodMetadata = beanDefinition.getFactoryMethodMetadata();
        }

        public AnnotationMetadata getMetadata() {
            return this.metadata;
        }

        public MethodMetadata getFactoryMethodMetadata() {
            return this.factoryMethodMetadata;
        }
    }

    class ProfileAwareReaderContext
    extends XmlReaderContext {
        private ReaderEventListener eventListener;

        public ProfileAwareReaderContext(Resource resource, ProblemReporter problemReporter, ReaderEventListener eventListener, SourceExtractor sourceExtractor, XmlBeanDefinitionReader reader, NamespaceHandlerResolver namespaceHandlerResolver) {
            super(resource, problemReporter, eventListener, sourceExtractor, reader, namespaceHandlerResolver);
            this.eventListener = eventListener;
        }

        public void fireComponentRegistered(ComponentDefinition componentDefinition) {
            CompositeComponentDefinition currentContext = BeansConfig.this.beanRegistrationTracker.currentContext();
            if (currentContext != null) {
                currentContext.addNestedComponent(componentDefinition);
            } else {
                this.eventListener.componentRegistered(componentDefinition);
            }
        }
    }

    class ScannedGenericBeanDefinitionSuppressingBeanDefinitionRegistry
    extends SimpleBeanDefinitionRegistry {
        ScannedGenericBeanDefinitionSuppressingBeanDefinitionRegistry() {
        }

        public void registerBeanDefinition(String beanName, BeanDefinition beanDefinition) throws BeanDefinitionStoreException {
            BeansConfig.this.beanRegistrationTracker.registerBean(beanName, beanDefinition);
            if (beanDefinition instanceof ScannedGenericBeanDefinition) {
                super.registerBeanDefinition(beanName, (BeanDefinition)new InternalScannedGenericBeanDefinition((ScannedGenericBeanDefinition)beanDefinition));
            } else {
                super.registerBeanDefinition(beanName, beanDefinition);
            }
        }
    }

    static class ToolingFriendlyBeanDefinitionDocumentReader
    extends DefaultBeanDefinitionDocumentReader {
        private BeanDefinitionParserDelegate delegate;
        private BeansConfig beansConfig;

        public ToolingFriendlyBeanDefinitionDocumentReader(BeansConfig beansConfig) {
            this.beansConfig = beansConfig;
        }

        protected void importBeanDefinitionResource(Element ele) {
            String location = ele.getAttribute("resource");
            if (SpringCoreUtils.hasPlaceHolder((String)location)) {
                this.getReaderContext().warning("Resource location contains placeholder", (Object)ele);
            } else {
                super.importBeanDefinitionResource(ele);
            }
        }

        protected BeanDefinitionParserDelegate createDelegate(XmlReaderContext readerContext, Element root, BeanDefinitionParserDelegate parentDelegate) {
            ErrorSuppressingBeanDefinitionParserDelegate delegate = new ErrorSuppressingBeanDefinitionParserDelegate(readerContext);
            delegate.initDefaults(root, parentDelegate);
            return delegate;
        }

        protected void processBeanDefinition(Element ele, BeanDefinitionParserDelegate delegate) {
            BeanDefinitionHolder bdHolder = delegate.parseBeanDefinitionElement(ele);
            if (bdHolder != null) {
                Object source = bdHolder.getSource();
                if ((bdHolder = delegate.decorateBeanDefinitionIfRequired(ele, bdHolder)).getSource() == null) {
                    ((AbstractBeanDefinition)bdHolder.getBeanDefinition()).setSource(source);
                }
                try {
                    BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)bdHolder, (BeanDefinitionRegistry)this.getReaderContext().getRegistry());
                }
                catch (BeanDefinitionStoreException ex) {
                    this.getReaderContext().error("Failed to register bean definition with name '" + bdHolder.getBeanName() + "'", (Object)ele, (Throwable)ex);
                }
                this.getReaderContext().fireComponentRegistered((ComponentDefinition)new BeanComponentDefinition(bdHolder));
            }
        }

        protected void doRegisterBeanDefinitions(Element root) {
            String profileSpec = root.getAttribute("profile");
            String[] specifiedProfiles = null;
            if (StringUtils.hasText((String)profileSpec)) {
                specifiedProfiles = StringUtils.tokenizeToStringArray((String)profileSpec, (String)",; ");
            }
            ProfileAwareCompositeComponentDefinition cd = new ProfileAwareCompositeComponentDefinition(root.getNodeName(), this.getReaderContext().extractSource((Object)root), specifiedProfiles);
            this.beansConfig.beanRegistrationTracker.enter(cd);
            try {
                BeanDefinitionParserDelegate parent = this.delegate;
                this.delegate = this.createDelegate(this.getReaderContext(), root, parent);
                this.preProcessXml(root);
                this.parseBeanDefinitions(root, this.delegate);
                this.postProcessXml(root);
                this.delegate = parent;
            }
            finally {
                this.beansConfig.beanRegistrationTracker.exit(cd);
                this.getReaderContext().fireComponentRegistered((ComponentDefinition)cd);
            }
        }
    }
}

