/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.quickfixes;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.sf.eclipsecs.core.config.meta.RuleMetadata;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.quickfixes.ICheckstyleMarkerResolution;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public abstract class AbstractASTResolution
extends WorkbenchMarkerResolution
implements ICheckstyleMarkerResolution {
    private boolean mAutoCommit;
    private RuleMetadata mMetaData;

    @Override
    public void setRuleMetaData(RuleMetadata metadata) {
        this.mMetaData = metadata;
    }

    @Override
    public boolean canFix(IMarker marker) {
        String moduleName = marker.getAttribute("ModuleName", null);
        try {
            return "net.sf.eclipsecs.core.CheckstyleMarker".equals(marker.getType()) && (this.mMetaData.getInternalName().equals(moduleName) || this.mMetaData.getAlternativeNames().contains(moduleName));
        }
        catch (CoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setAutoCommitChanges(boolean autoCommit) {
        this.mAutoCommit = autoCommit;
    }

    public Image getImage() {
        return null;
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        HashSet<IMarker> candidates = new HashSet<IMarker>();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker m = iMarkerArray[n2];
            if (this.canFix(m)) {
                candidates.add(m);
            }
            ++n2;
        }
        return candidates.toArray(new IMarker[candidates.size()]);
    }

    public void run(IMarker marker) {
        IResource resource = marker.getResource();
        if (!(resource instanceof IFile)) {
            return;
        }
        ICompilationUnit compilationUnit = this.getCompilationUnit(marker);
        if (compilationUnit == null) {
            return;
        }
        ITextFileBufferManager bufferManager = null;
        IPath path = compilationUnit.getPath();
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            JavaUI.openInEditor((IJavaElement)compilationUnit);
            bufferManager = FileBuffers.getTextFileBufferManager();
            bufferManager.connect(path, null);
            ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(path);
            IDocument document = textFileBuffer.getDocument();
            IAnnotationModel annotationModel = textFileBuffer.getAnnotationModel();
            MarkerAnnotation annotation = this.getMarkerAnnotation(annotationModel, marker);
            if (annotation == null) {
                return;
            }
            try {
                Position pos = annotationModel.getPosition((Annotation)annotation);
                IRegion lineInfo = document.getLineInformationOfOffset(pos.getOffset());
                int markerStart = pos.getOffset();
                ASTParser astParser = ASTParser.newParser((int)3);
                astParser.setKind(8);
                astParser.setSource(compilationUnit);
                CompilationUnit ast = (CompilationUnit)astParser.createAST((IProgressMonitor)monitor);
                ast.recordModifications();
                ast.accept(this.handleGetCorrectingASTVisitor(lineInfo, markerStart));
                TextEdit edit = ast.rewrite(document, compilationUnit.getJavaProject().getOptions(true));
                edit.apply(document);
                if (this.mAutoCommit) {
                    textFileBuffer.commit((IProgressMonitor)monitor, false);
                }
            }
            catch (CoreException e) {
                CheckstyleLog.log((Throwable)e, (String)Messages.AbstractASTResolution_msgErrorQuickfix);
            }
            catch (MalformedTreeException e) {
                CheckstyleLog.log((Throwable)e, (String)Messages.AbstractASTResolution_msgErrorQuickfix);
            }
            catch (BadLocationException e) {
                CheckstyleLog.log((Throwable)e, (String)Messages.AbstractASTResolution_msgErrorQuickfix);
            }
        }
        finally {
            if (bufferManager != null) {
                try {
                    bufferManager.disconnect(path, null);
                }
                catch (CoreException e) {
                    CheckstyleLog.log((Throwable)e, (String)"Error processing quickfix");
                }
            }
        }
    }

    protected abstract ASTVisitor handleGetCorrectingASTVisitor(IRegion var1, int var2);

    protected boolean containsPosition(ASTNode node, int position) {
        return node.getStartPosition() <= position && position <= node.getStartPosition() + node.getLength();
    }

    protected boolean containsPosition(IRegion region, int position) {
        return region.getOffset() <= position && position <= region.getOffset() + region.getLength();
    }

    protected <T extends ASTNode> T copy(T node) {
        return (T)ASTNode.copySubtree((AST)node.getAST(), node);
    }

    protected boolean replace(ASTNode node, ASTNode replacement) {
        ASTNode parent = node.getParent();
        StructuralPropertyDescriptor descriptor = node.getLocationInParent();
        if (descriptor != null) {
            if (descriptor.isChildProperty()) {
                parent.setStructuralProperty(descriptor, (Object)replacement);
                node.delete();
                return true;
            }
            if (descriptor.isChildListProperty()) {
                List children = (List)parent.getStructuralProperty(descriptor);
                children.set(children.indexOf(node), replacement);
                node.delete();
                return true;
            }
        }
        return false;
    }

    private ICompilationUnit getCompilationUnit(IMarker marker) {
        IJavaElement element;
        IResource res = marker.getResource();
        if (res instanceof IFile && res.isAccessible() && (element = JavaCore.create((IFile)((IFile)res))) instanceof ICompilationUnit) {
            return (ICompilationUnit)element;
        }
        return null;
    }

    private MarkerAnnotation getMarkerAnnotation(IAnnotationModel annotationModel, IMarker marker) {
        Iterator it = annotationModel.getAnnotationIterator();
        while (it.hasNext()) {
            IMarker theMarker;
            Annotation tmp = (Annotation)it.next();
            if (!(tmp instanceof MarkerAnnotation) || !(theMarker = ((MarkerAnnotation)tmp).getMarker()).equals((Object)marker)) continue;
            return (MarkerAnnotation)tmp;
        }
        return null;
    }
}

