/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.properties;

import java.util.List;
import net.sf.eclipsecs.core.projectconfig.FileSet;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.config.CheckConfigurationLabelProvider;
import net.sf.eclipsecs.ui.properties.CheckstylePropertyPage;
import net.sf.eclipsecs.ui.properties.FileSetEditDialog;
import net.sf.eclipsecs.ui.properties.IFileSetsEditor;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ComplexFileSetsEditor
implements IFileSetsEditor {
    private final IProject mProject;
    private Composite mComposite;
    private CheckboxTableViewer mViewer;
    private Button mAddButton;
    private Button mEditButton;
    private Button mRemoveButton;
    private List<FileSet> mFileSets;
    private final CheckstylePropertyPage mPropertyPage;

    public ComplexFileSetsEditor(CheckstylePropertyPage propsPage) {
        this.mPropertyPage = propsPage;
        this.mProject = (IProject)propsPage.getElement();
    }

    @Override
    public void setFileSets(List<FileSet> fileSets) {
        this.mFileSets = fileSets;
    }

    @Override
    public List<FileSet> getFileSets() {
        return this.mFileSets;
    }

    @Override
    public Control createContents(Composite parent) throws CheckstylePluginException {
        this.mComposite = parent;
        Group composite = new Group(parent, 0);
        composite.setText(Messages.ComplexFileSetsEditor_titleAdvancedFilesetEditor);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Table table = new Table((Composite)composite, 67616);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(Messages.ComplexFileSetsEditor_colEnabled);
        column1.setResizable(false);
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(Messages.ComplexFileSetsEditor_colFilesetName);
        TableColumn column3 = new TableColumn(table, 0);
        column3.setText(Messages.ComplexFileSetsEditor_colConfiguration);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        this.mViewer = new CheckboxTableViewer(table);
        this.mViewer.setLabelProvider((IBaseLabelProvider)new FileSetLabelProvider());
        this.mViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.mViewer.setComparator((ViewerComparator)new FileSetViewerSorter());
        this.mViewer.setInput(this.mFileSets);
        for (FileSet fileSet : this.mFileSets) {
            this.mViewer.setChecked((Object)fileSet, fileSet.isEnabled());
        }
        this.mViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                ComplexFileSetsEditor.this.editFileSet();
            }
        });
        this.mViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ComplexFileSetsEditor.this.changeEnabledState(event);
            }
        });
        Composite buttons = new Composite((Composite)composite, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.mAddButton = this.createPushButton(buttons, Messages.ComplexFileSetsEditor_btnAdd);
        this.mAddButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                ComplexFileSetsEditor.this.addFileSet();
            }
        });
        this.mEditButton = this.createPushButton(buttons, Messages.ComplexFileSetsEditor_btnEdit);
        this.mEditButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                ComplexFileSetsEditor.this.editFileSet();
            }
        });
        this.mRemoveButton = this.createPushButton(buttons, Messages.ComplexFileSetsEditor_btnRemove);
        this.mRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                ComplexFileSetsEditor.this.removeFileSet();
            }
        });
        return composite;
    }

    @Override
    public void refresh() {
    }

    private Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    private void addFileSet() {
        try {
            FileSetEditDialog dialog = new FileSetEditDialog(this.mComposite.getShell(), null, this.mProject, this.mPropertyPage);
            if (dialog.open() == 0) {
                FileSet fileSet = dialog.getFileSet();
                this.mFileSets.add(fileSet);
                this.mViewer.refresh();
                this.mViewer.setChecked((Object)fileSet, fileSet.isEnabled());
                this.mPropertyPage.getContainer().updateButtons();
            }
        }
        catch (CheckstylePluginException e) {
            CheckstyleUIPlugin.errorDialog(this.mComposite.getShell(), NLS.bind((String)Messages.errorFailedAddFileset, (Object)e.getMessage()), e, true);
        }
    }

    private void editFileSet() {
        IStructuredSelection selection = (IStructuredSelection)this.mViewer.getSelection();
        FileSet fileSet = (FileSet)selection.getFirstElement();
        if (fileSet == null) {
            return;
        }
        try {
            FileSetEditDialog dialog = new FileSetEditDialog(this.mComposite.getShell(), fileSet.clone(), this.mProject, this.mPropertyPage);
            if (dialog.open() == 0) {
                FileSet newFileSet = dialog.getFileSet();
                this.mFileSets.remove(fileSet);
                this.mFileSets.add(newFileSet);
                this.mViewer.refresh();
                this.mViewer.setChecked((Object)newFileSet, newFileSet.isEnabled());
                this.mPropertyPage.getContainer().updateButtons();
            }
        }
        catch (CheckstylePluginException e) {
            CheckstyleUIPlugin.errorDialog(this.mComposite.getShell(), NLS.bind((String)Messages.errorFailedEditFileset, (Object)e.getMessage()), e, true);
        }
    }

    private void removeFileSet() {
        IStructuredSelection selection = (IStructuredSelection)this.mViewer.getSelection();
        FileSet fileSet = (FileSet)selection.getFirstElement();
        if (fileSet == null) {
            return;
        }
        this.mFileSets.remove(fileSet);
        this.mViewer.refresh();
        this.mPropertyPage.getContainer().updateButtons();
    }

    private void changeEnabledState(CheckStateChangedEvent event) {
        if (event.getElement() instanceof FileSet) {
            FileSet fileSet = (FileSet)event.getElement();
            fileSet.setEnabled(event.getChecked());
            this.mViewer.refresh();
        }
    }

    class FileSetLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private final CheckConfigurationLabelProvider mCheckConfigLabelProvider = new CheckConfigurationLabelProvider();

        FileSetLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = element.toString();
            if (element instanceof FileSet) {
                FileSet fileSet = (FileSet)element;
                switch (columnIndex) {
                    case 0: {
                        result = new String();
                        break;
                    }
                    case 1: {
                        result = fileSet.getName();
                        break;
                    }
                    case 2: {
                        result = fileSet.getCheckConfig() != null ? this.mCheckConfigLabelProvider.getText(fileSet.getCheckConfig()) : "";
                        break;
                    }
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    public class FileSetViewerSorter
    extends ViewerComparator {
        public int compare(Viewer viewer, Object e1, Object e2) {
            int result = 0;
            if (e1 instanceof FileSet && e2 instanceof FileSet) {
                FileSet fileSet1 = (FileSet)e1;
                FileSet fileSet2 = (FileSet)e2;
                String name1 = fileSet1.getName();
                String name2 = fileSet2.getName();
                result = name1.compareTo(name2);
            }
            return result;
        }
    }
}

