/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.core.builder;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.ide.eclipse.aop.core.Activator;
import org.springframework.ide.eclipse.aop.core.internal.model.AopReferenceModel;
import org.springframework.ide.eclipse.aop.core.internal.model.builder.AopReferenceModelBuilderJob;
import org.springframework.ide.eclipse.aop.core.util.AopReferenceModelMarkerUtils;
import org.springframework.ide.eclipse.aop.core.util.AopReferenceModelUtils;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.project.IProjectBuilder;
import org.springframework.ide.eclipse.core.project.IProjectContributorState;
import org.springframework.ide.eclipse.core.project.IProjectContributorStateAware;

public class AopReferenceModelProjectBuilder
implements IProjectBuilder,
IProjectContributorStateAware {
    private IProjectContributorState context = null;

    public Set<IResource> getAffectedResources(IResource resource, int kind, int deltaKind) throws CoreException {
        LinkedHashSet<IResource> resources = new LinkedHashSet<IResource>();
        if (resource instanceof IFile) {
            resources.addAll(AopReferenceModelUtils.getAffectedFiles(kind, deltaKind, resource, this.context));
        }
        return resources;
    }

    public void build(Set<IResource> affectedResources, int kind, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(Activator.getFormattedMessage("AopReferenceModelProjectBuilder.buildingAopReferenceModel", new Object[0]));
        if (affectedResources.size() > 0) {
            IProject project = (IProject)this.context.get(IProject.class);
            if (kind == 15 || kind == 6) {
                AopReferenceModelMarkerUtils.deleteProblemMarkers((IResource)project);
                ((AopReferenceModel)Activator.getModel()).removeProject(JdtUtils.getJavaProject((IProject)project));
            }
            AopReferenceModelBuilderJob job = new AopReferenceModelBuilderJob(project, AopReferenceModelUtils.getAffectedFilesFromBeansConfig(affectedResources), affectedResources);
            job.schedule();
        }
        monitor.done();
    }

    public void cleanup(IResource resource, IProgressMonitor monitor) {
        try {
            monitor.subTask(Activator.getFormattedMessage("AopReferenceModelProjectBuilder.deletedProblemMarkers", resource.getFullPath()));
            AopReferenceModelMarkerUtils.deleteProblemMarkers(resource);
            IProject project = resource.getProject();
            if (JdtUtils.isJavaProject((IResource)project)) {
                Activator.getModel().removeProject(JdtUtils.getJavaProject((IProject)project));
            }
        }
        finally {
            monitor.done();
        }
    }

    public void setProjectContributorState(IProjectContributorState context) {
        this.context = context;
    }
}

