/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.ui.matcher;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.springframework.ide.eclipse.aop.ui.matcher.PointcutMatcherPlugin;
import org.springframework.ide.eclipse.aop.ui.matcher.internal.PointcutMatchQuery;
import org.springframework.ide.eclipse.aop.ui.matcher.internal.PointcutMatcherMessages;
import org.springframework.ide.eclipse.aop.ui.matcher.internal.PointcutMatcherScope;

public class PointcutMatcherSearchPage
extends DialogPage
implements ISearchPage {
    private static final int HISTORY_SIZE = 12;
    private static final String PAGE_NAME = "PointcutMatcherPage";
    private static final String STORE_PROXY_TARGET_CLASS = "PROXY_TARGET_CLASS";
    private static final String STORE_HISTORY = "HISTORY";
    private static final String STORE_HISTORY_SIZE = "HISTORY_SIZE";
    private final List<PointcutMatchData> previousPointcutMatchData = new ArrayList<PointcutMatchData>();
    private boolean firstTime = true;
    private IDialogSettings dialogSettings;
    private boolean isProxyTargetClass;
    private Combo expressionCombo;
    private ISearchPageContainer searchContainer;
    private CLabel statusLabel;
    private Button proxyTargetClassCheckbox;
    private PointcutMatcherScope scope;

    public PointcutMatcherSearchPage() {
    }

    public PointcutMatcherSearchPage(String title) {
        super(title);
    }

    public PointcutMatcherSearchPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.readConfiguration();
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        result.setLayout((Layout)layout);
        Control expressionComposite = this.createExpression(result);
        expressionComposite.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Label separator = new Label(result, 0);
        separator.setVisible(false);
        GridData data = new GridData(4, 4, false, false, 2, 1);
        data.heightHint = this.convertHeightInCharsToPixels(1) / 3;
        separator.setLayoutData((Object)data);
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
    }

    private Control createExpression(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        Label label = new Label(group, 16384);
        label.setText(PointcutMatcherMessages.MatcherPage_expression);
        label.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.expressionCombo = new Combo(group, 2052);
        this.expressionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PointcutMatcherSearchPage.this.handlePatternSelected();
                PointcutMatcherSearchPage.this.updateOKStatus();
            }
        });
        this.expressionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PointcutMatcherSearchPage.this.updateOKStatus();
            }
        });
        GridData data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.expressionCombo.setLayoutData((Object)data);
        this.proxyTargetClassCheckbox = new Button(group, 32);
        this.proxyTargetClassCheckbox.setText(PointcutMatcherMessages.MatcherPage_proxyTargetClass);
        this.proxyTargetClassCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PointcutMatcherSearchPage.this.isProxyTargetClass = PointcutMatcherSearchPage.this.proxyTargetClassCheckbox.getSelection();
            }
        });
        this.proxyTargetClassCheckbox.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.statusLabel = new CLabel(group, 16384);
        this.statusLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.statusLabel.setFont(group.getFont());
        this.statusLabel.setAlignment(16384);
        this.statusLabel.setText(PointcutMatcherMessages.MatcherPage_expressionHint);
        return group;
    }

    public void dispose() {
        this.writeConfiguration();
        super.dispose();
    }

    private PointcutMatchData findInPrevious(String pattern) {
        for (PointcutMatchData element : this.previousPointcutMatchData) {
            if (!pattern.equals(element.getExpression())) continue;
            return element;
        }
        return null;
    }

    private PointcutMatchData getDefaultInitValues() {
        if (!this.previousPointcutMatchData.isEmpty()) {
            return this.previousPointcutMatchData.get(0);
        }
        return new PointcutMatchData("", false);
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = PointcutMatcherPlugin.getDefault().getDialogSettings();
        this.dialogSettings = settings.getSection(PAGE_NAME);
        if (this.dialogSettings == null) {
            this.dialogSettings = settings.addNewSection(PAGE_NAME);
        }
        return this.dialogSettings;
    }

    private String getExpression() {
        return this.expressionCombo.getText();
    }

    private PointcutMatchData getPatternData() {
        String pattern = this.getExpression();
        PointcutMatchData match = this.findInPrevious(pattern);
        if (match != null) {
            this.previousPointcutMatchData.remove(match);
        }
        match = new PointcutMatchData(pattern, this.isProxyTargetClass(), this.searchContainer.getSelectedScope(), this.searchContainer.getSelectedWorkingSets());
        this.previousPointcutMatchData.add(0, match);
        return match;
    }

    private String[] getPreviousExpressions() {
        int patternCount = this.previousPointcutMatchData.size();
        String[] patterns = new String[patternCount];
        int i = 0;
        while (i < patternCount) {
            patterns[i] = this.previousPointcutMatchData.get(i).getExpression();
            ++i;
        }
        return patterns;
    }

    private void handlePatternSelected() {
        int selectionIndex = this.expressionCombo.getSelectionIndex();
        if (selectionIndex < 0 || selectionIndex >= this.previousPointcutMatchData.size()) {
            return;
        }
        PointcutMatchData data = this.previousPointcutMatchData.get(selectionIndex);
        this.expressionCombo.setText(data.getExpression());
        this.isProxyTargetClass = data.isProxyTargetClass();
        this.proxyTargetClassCheckbox.setSelection(data.isProxyTargetClass());
        if (data.getWorkingSets() != null) {
            this.searchContainer.setSelectedWorkingSets(data.getWorkingSets());
        } else {
            this.searchContainer.setSelectedScope(data.getScope());
        }
    }

    private void initSelections() {
        PointcutMatchData initData = null;
        if (initData == null) {
            initData = this.getDefaultInitValues();
        }
        this.expressionCombo.setText(initData.getExpression());
        this.proxyTargetClassCheckbox.setSelection(initData.isProxyTargetClass());
    }

    private boolean isProxyTargetClass() {
        return this.proxyTargetClassCheckbox.getSelection();
    }

    private boolean isValidExpression() {
        return this.getExpression().length() != 0;
    }

    public boolean performAction() {
        switch (this.searchContainer.getSelectedScope()) {
            case 1: {
                this.scope = PointcutMatcherScope.newSearchScope(this.searchContainer.getSelection(), false);
                break;
            }
            case 2: {
                this.scope = PointcutMatcherScope.newSearchScope(this.searchContainer.getSelectedWorkingSets());
                break;
            }
            case 3: {
                this.scope = PointcutMatcherScope.newSearchScope(this.searchContainer.getSelection(), true);
                break;
            }
            default: {
                this.scope = PointcutMatcherScope.newSearchScope();
            }
        }
        PointcutMatchData data = this.getPatternData();
        PointcutMatchQuery query = new PointcutMatchQuery(this.scope, data.getExpression(), data.isProxyTargetClass());
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInBackground((ISearchQuery)query);
        return true;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        this.isProxyTargetClass = s.getBoolean(STORE_PROXY_TARGET_CLASS);
        try {
            int historySize = s.getInt(STORE_HISTORY_SIZE);
            int i = 0;
            while (i < historySize) {
                PointcutMatchData data;
                IDialogSettings histSettings = s.getSection(STORE_HISTORY + i);
                if (histSettings != null && (data = PointcutMatchData.create(histSettings)) != null) {
                    this.previousPointcutMatchData.add(data);
                }
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void setContainer(ISearchPageContainer container) {
        this.searchContainer = container;
    }

    public void setVisible(boolean visible) {
        if (visible && this.expressionCombo != null) {
            if (this.firstTime) {
                this.firstTime = false;
                this.expressionCombo.setItems(this.getPreviousExpressions());
                this.initSelections();
            }
            this.expressionCombo.setFocus();
        }
        this.updateOKStatus();
        super.setVisible(visible);
    }

    final void updateOKStatus() {
        boolean isValid = this.isValidExpression();
        this.searchContainer.setPerformActionEnabled(isValid);
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        s.put(STORE_PROXY_TARGET_CLASS, this.isProxyTargetClass);
        int historySize = Math.min(this.previousPointcutMatchData.size(), 12);
        s.put(STORE_HISTORY_SIZE, historySize);
        int i = 0;
        while (i < historySize) {
            IDialogSettings histSettings = s.addNewSection(STORE_HISTORY + i);
            PointcutMatchData data = this.previousPointcutMatchData.get(i);
            data.store(histSettings);
            ++i;
        }
    }

    private static class PointcutMatchData {
        private String expression;
        private boolean isProxyTargetClass;
        private int scope;
        private IWorkingSet[] workingSets;

        public static PointcutMatchData create(IDialogSettings settings) {
            String pattern = settings.get("pattern");
            if (pattern.length() == 0) {
                return null;
            }
            String[] wsIds = settings.getArray("workingSets");
            IWorkingSet[] workingSets = null;
            if (wsIds != null && wsIds.length > 0) {
                IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                workingSets = new IWorkingSet[wsIds.length];
                int i = 0;
                while (workingSets != null && i < wsIds.length) {
                    workingSets[i] = workingSetManager.getWorkingSet(wsIds[i]);
                    if (workingSets[i] == null) {
                        workingSets = null;
                    }
                    ++i;
                }
            }
            try {
                int scope = settings.getInt("scope");
                boolean isProxyTargetClass = settings.getBoolean("isProxyTargetClass");
                return new PointcutMatchData(pattern, isProxyTargetClass, scope, workingSets);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        public PointcutMatchData(String pattern, boolean isProxyTargetClass) {
            this(pattern, isProxyTargetClass, 0, null);
        }

        public PointcutMatchData(String pattern, boolean isProxyTargetClass, int scope, IWorkingSet[] workingSets) {
            this.expression = pattern;
            this.isProxyTargetClass = isProxyTargetClass;
            this.scope = scope;
            this.workingSets = workingSets;
        }

        public String getExpression() {
            return this.expression;
        }

        public int getScope() {
            return this.scope;
        }

        public IWorkingSet[] getWorkingSets() {
            return this.workingSets;
        }

        public boolean isProxyTargetClass() {
            return this.isProxyTargetClass;
        }

        public void store(IDialogSettings settings) {
            settings.put("pattern", this.expression);
            settings.put("isProxyTargetClass", this.isProxyTargetClass);
            settings.put("scope", this.scope);
            if (this.workingSets != null) {
                String[] wsIds = new String[this.workingSets.length];
                int i = 0;
                while (i < this.workingSets.length) {
                    wsIds[i] = this.workingSets[i].getId();
                    ++i;
                }
                settings.put("workingSets", wsIds);
            } else {
                settings.put("workingSets", new String[0]);
            }
        }
    }
}

