/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.ui.launch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.springsource.ide.eclipse.commons.ui.launch.LaunchList;

public class LiveAndDeadProcessTracker
extends LaunchList {
    private static final boolean DEBUG = false;
    private static LiveAndDeadProcessTracker instance;
    private final LinkedHashMap<String, ProcessItem> configs = new LinkedHashMap();
    private ProcessItem last = null;

    public static synchronized LaunchList getInstance() {
        if (instance == null) {
            instance = new LiveAndDeadProcessTracker();
        }
        return instance;
    }

    @Override
    protected void processTerminated(IProcess process) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processCreated(IProcess process) {
        IProcess iProcess = process;
        synchronized (iProcess) {
            ILaunchConfiguration c;
            ILaunch l = process.getLaunch();
            if (l != null && (c = l.getLaunchConfiguration()) != null) {
                this.last = new ProcessItem(c, l.getLaunchMode(), process);
                this.configs.remove(this.last.getName());
                this.configs.put(this.last.getName(), this.last);
            }
        }
        this.fireChangeEvent();
    }

    private boolean exists(ILaunchConfiguration conf) {
        return conf.exists() || conf.isWorkingCopy();
    }

    @Override
    public synchronized LaunchList.Item getLast() {
        if (this.last != null) {
            if (this.exists(this.last.conf)) {
                return this.last;
            }
            this.last = this.findRenamed(this.last);
            if (this.last == null) {
                for (LaunchList.Item newLast : this.getLaunches()) {
                    this.last = (ProcessItem)newLast;
                }
            }
        }
        return this.last;
    }

    @Override
    public synchronized Collection<LaunchList.Item> getLaunches() {
        ArrayList<String> names = new ArrayList<String>(this.configs.keySet());
        for (String name : names) {
            ProcessItem item = this.configs.get(name);
            ILaunchConfiguration conf = item.conf;
            if (this.exists(conf)) continue;
            ProcessItem renamedItem = this.findRenamed(item);
            if (renamedItem != null) {
                this.configs.remove(item.getName());
                this.configs.put(renamedItem.getName(), renamedItem);
                continue;
            }
            this.configs.remove(item.getName());
        }
        ArrayList<LaunchList.Item> items = new ArrayList<LaunchList.Item>(this.configs.values());
        return items;
    }

    private ProcessItem findRenamed(ProcessItem item) {
        ILaunchConfiguration renamedConf;
        ILaunch l = item.process.getLaunch();
        if (l != null && (renamedConf = l.getLaunchConfiguration()) != null && this.exists(renamedConf)) {
            return item.setConf(renamedConf);
        }
        return null;
    }

    private void debug(String string) {
    }

    public class ProcessItem
    extends LaunchList.Item {
        private final IProcess process;

        public ProcessItem(ILaunchConfiguration conf, String mode, IProcess process) {
            super(conf, mode);
            this.process = process;
        }

        public ProcessItem setConf(ILaunchConfiguration newConf) {
            return new ProcessItem(newConf, this.mode, this.process);
        }
    }
}

