/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.ui.launch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.springsource.ide.eclipse.commons.frameworks.core.async.ResolvableFuture;
import org.springsource.ide.eclipse.commons.ui.launch.UiRunnable;

public class LaunchUtils {
    private static final boolean DEBUG = ("" + Platform.getLocation()).contains("kdvolder");

    private static void debug(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    public static void whenTerminated(Collection<ILaunch> launches, Runnable runnable) {
        new WhenTerminated(new ArrayList<ILaunch>(launches), runnable);
    }

    public static Future<Void> whenTerminated(ILaunch l) {
        return LaunchUtils.whenTerminated(Arrays.asList(l));
    }

    public static Future<Void> whenTerminated(List<ILaunch> launches) {
        final ResolvableFuture done = new ResolvableFuture();
        LaunchUtils.whenTerminated(launches, new Runnable(){

            @Override
            public void run() {
                done.resolve(null);
            }
        });
        return done;
    }

    public static void terminateAndRelaunch(final ILaunchConfiguration launchConf, final String mode) throws DebugException {
        List<ILaunch> launches = LaunchUtils.getLaunches(launchConf);
        LaunchUtils.terminate(launches);
        LaunchUtils.whenTerminated(launches, new UiRunnable(){

            @Override
            protected void uiRun() {
                DebugUITools.launch((ILaunchConfiguration)launchConf, (String)mode);
            }
        });
    }

    public static void terminate(List<ILaunch> launches) throws DebugException {
        for (ILaunch l : launches) {
            if (l.isTerminated()) continue;
            l.terminate();
        }
    }

    public static List<ILaunch> getLaunches(ILaunchConfiguration launchConf) {
        ILaunch[] all = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        ArrayList<ILaunch> selected = new ArrayList<ILaunch>();
        ILaunch[] iLaunchArray = all;
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch l = iLaunchArray[n2];
            ILaunchConfiguration lConf = l.getLaunchConfiguration();
            if (lConf != null && lConf.equals(launchConf)) {
                selected.add(l);
            }
            ++n2;
        }
        return selected;
    }

    public static void terminate(ILaunchConfiguration conf) throws DebugException {
        LaunchUtils.terminate(LaunchUtils.getLaunches(conf));
    }

    private static class WhenTerminated
    implements IDebugEventSetListener {
        private final List<ILaunch> launches;
        private Runnable runnable;
        private final DebugPlugin debugPlugin;

        public WhenTerminated(List<ILaunch> launches, Runnable runnable) {
            this.launches = launches;
            this.runnable = runnable;
            this.debugPlugin = DebugPlugin.getDefault();
            this.debugPlugin.addDebugEventListener((IDebugEventSetListener)this);
            this.checkAndRun();
        }

        public void handleDebugEvents(DebugEvent[] events) {
            DebugEvent[] debugEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                DebugEvent e = debugEventArray[n2];
                if (e.getKind() == 8) {
                    this.checkAndRun();
                }
                ++n2;
            }
        }

        private void checkAndRun() {
            Runnable runit = this.check();
            if (runit != null) {
                this.debugPlugin.removeDebugEventListener((IDebugEventSetListener)this);
                runit.run();
            }
        }

        private synchronized Runnable check() {
            if (this.runnable != null) {
                Iterator<ILaunch> iter = this.launches.iterator();
                while (iter.hasNext()) {
                    ILaunch l = iter.next();
                    if (!l.isTerminated()) continue;
                    iter.remove();
                }
                if (this.launches.isEmpty()) {
                    Runnable it = this.runnable;
                    this.runnable = null;
                    return it;
                }
            }
            return null;
        }
    }
}

