/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.ui;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.internal.text.html.HTML2TextReader;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.springsource.ide.eclipse.commons.internal.ui.UiPlugin;
import org.springsource.ide.eclipse.commons.ui.HTMLPrinter;
import org.springsource.ide.eclipse.commons.ui.ToolTip;

public class HtmlTooltip
extends ToolTip {
    private static final int MIN_WIDTH = 50;
    private static final int MIN_HEIGHT = 10;
    private static final Pattern FONT_SIZE_PATTERN;
    private static final Pattern FONT_STYLE_PATTERN;
    private static final Pattern FONT_FAMILY_PATTERN;
    private static final Pattern FONT_WEIGHT_PATTERN;
    private Supplier<String> html;
    private Point maxSizeConstraints = new Point(-1, -1);

    static {
        HTMLPrinter.insertPageProlog(new StringBuilder(), 0);
        Display.getDefault().syncExec(() -> {});
        FONT_SIZE_PATTERN = Pattern.compile("html\\s*\\{.*(?:\\s|;)?font-size:\\s*(\\d+)(pt|px|em)?\\;?.*\\}");
        FONT_STYLE_PATTERN = Pattern.compile("html\\s*\\{.*(?:\\s|;)?font-style:\\s*(\\w+)\\;?.*\\}");
        FONT_FAMILY_PATTERN = Pattern.compile("html\\s*\\{.*(?:\\s|;)?font-family:\\s*(.+?);.*\\}");
        FONT_WEIGHT_PATTERN = Pattern.compile("html\\s*\\{.*(?:\\s|;)?font-weight:\\s*(\\w+)\\;?.*\\}");
    }

    public HtmlTooltip(Control control) {
        super(control, 2, false);
        this.setHideOnMouseDown(false);
        this.setShift(new Point(1, 1));
    }

    @Override
    protected Composite createToolTipContentArea(Event event, Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        Browser browser = new Browser(composite, 0);
        browser.setForeground(parent.getDisplay().getSystemColor(28));
        browser.setBackground(parent.getDisplay().getSystemColor(29));
        browser.setJavascriptEnabled(false);
        browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                event.required = true;
            }
        });
        browser.setMenu(new Menu((Decorations)browser.getShell(), 0));
        String htmlContent = this.html.get();
        browser.setText(htmlContent);
        Point size = this.computeSizeHint(browser, htmlContent);
        browser.setLayoutData((Object)GridDataFactory.swtDefaults().hint(size.x, size.y).create());
        browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent event) {
                super.changing(event);
                event.doit = false;
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().createBrowser(null).openURL(new URL(event.location));
                    HtmlTooltip.this.hide();
                }
                catch (MalformedURLException | PartInitException e) {
                    UiPlugin.log(e);
                }
            }
        });
        return composite;
    }

    @Override
    protected Object getToolTipArea(Event event) {
        Object r = super.getToolTipArea(event);
        return r;
    }

    public void setHtml(Supplier<String> html) {
        this.html = html;
    }

    public void setMaxSize(int maxWidth, int maxHeight) {
        this.maxSizeConstraints = maxWidth > 0 && maxHeight > 0 ? new Point(maxWidth, maxHeight) : new Point(-1, -1);
    }

    private Point computeSizeHint(Browser browser, String html) {
        TextLayout fTextLayout = new TextLayout((Device)browser.getDisplay());
        Font defaultFont = JFaceResources.getFont((String)"org.eclipse.jface.dialogfont");
        FontData fd = defaultFont.getFontData()[0];
        String family = fd.getName();
        int size = fd.getHeight();
        int style = 0;
        Matcher matcher = FONT_FAMILY_PATTERN.matcher(html);
        if (matcher.find()) {
            family = matcher.group(1);
        }
        if ((matcher = FONT_SIZE_PATTERN.matcher(html)).find()) {
            try {
                size = Integer.valueOf(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((matcher = FONT_STYLE_PATTERN.matcher(html)).find() && "italic".equalsIgnoreCase(matcher.group(1))) {
            style |= 2;
        }
        if ((matcher = FONT_WEIGHT_PATTERN.matcher(html)).find() && "bold".equalsIgnoreCase(matcher.group(1))) {
            style |= 1;
        }
        Font font = null;
        Font boldFont = null;
        try {
            String text;
            font = new Font(defaultFont.getDevice(), new FontData(family, size, style));
            fTextLayout.setFont(font);
            fTextLayout.setWidth(-1);
            boldFont = new Font(font.getDevice(), new FontData(family, size, style | 1));
            TextStyle fBoldStyle = new TextStyle(boldFont, null, null);
            fTextLayout.setText("    ");
            int tabWidth = fTextLayout.getBounds().width;
            fTextLayout.setTabs(new int[]{tabWidth});
            fTextLayout.setText("");
            Rectangle trim = new Rectangle(0, 0, 35, 20);
            int height = trim.height;
            TextPresentation presentation = new TextPresentation();
            try {
                Throwable throwable = null;
                Object var19_21 = null;
                try (HTML2TextReader reader = new HTML2TextReader((Reader)new StringReader(html), presentation);){
                    text = reader.getString();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                text = "";
            }
            fTextLayout.setText(text);
            fTextLayout.setWidth(this.maxSizeConstraints == null || this.maxSizeConstraints.x < trim.width ? -1 : this.maxSizeConstraints.x - trim.width);
            Iterator iter = presentation.getAllStyleRangeIterator();
            while (iter.hasNext()) {
                StyleRange sr = (StyleRange)iter.next();
                if (sr.fontStyle != 1) continue;
                fTextLayout.setStyle(fBoldStyle, sr.start, sr.start + sr.length - 1);
            }
            Rectangle bounds = fTextLayout.getBounds();
            int lineCount = fTextLayout.getLineCount();
            int textWidth = 0;
            int i = 0;
            while (i < lineCount) {
                Rectangle rect = fTextLayout.getLineBounds(i);
                int lineWidth = rect.x + rect.width;
                textWidth = Math.max(textWidth, lineWidth);
                ++i;
            }
            bounds.width = textWidth;
            fTextLayout.setText("");
            int minWidth = bounds.width;
            height += bounds.height;
            if (this.maxSizeConstraints != null) {
                if (this.maxSizeConstraints.x != -1) {
                    minWidth = Math.min(this.maxSizeConstraints.x, minWidth + trim.width);
                }
                if (this.maxSizeConstraints.y != -1) {
                    height = Math.min(this.maxSizeConstraints.y, height);
                }
            }
            int width = Math.max(50, minWidth);
            height = Math.max(10, height);
            fTextLayout.dispose();
            font.dispose();
            boldFont.dispose();
            Point point = new Point(width, height);
            return point;
        }
        finally {
            if (font != null) {
                font.dispose();
            }
            if (boldFont != null) {
                boldFont.dispose();
            }
        }
    }
}

