/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.internal.ui;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.IStartup;
import org.osgi.service.prefs.BackingStoreException;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;
import org.springsource.ide.eclipse.commons.internal.ui.UiPlugin;

public class EgitPreferencesFixer
implements IStartup {
    private final IEclipsePreferences ourPrefs = InstanceScope.INSTANCE.getNode("org.springsource.ide.eclipse.commons.ui");
    private final IEclipsePreferences egitPrefs = InstanceScope.INSTANCE.getNode("org.eclipse.egit.core");
    boolean dirty = false;

    private boolean shouldFixKey(String key) {
        String wasFixedKey = "egit.pref.fixed." + key;
        boolean wasFixed = this.ourPrefs.getBoolean(wasFixedKey, false);
        if (!wasFixed) {
            this.ourPrefs.putBoolean(wasFixedKey, true);
            this.dirty = true;
        }
        return !wasFixed;
    }

    public void earlyStartup() {
        this.set("core_autoIgnoreDerivedResources", "false");
        this.flush();
    }

    private void flush() {
        if (this.dirty) {
            this.flush(this.ourPrefs);
            this.flush(this.egitPrefs);
        }
    }

    private void flush(IEclipsePreferences prefs) {
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            UiPlugin.getDefault().getLog().log(ExceptionUtil.status((Throwable)e));
        }
    }

    private void set(String key, String value) {
        if (this.shouldFixKey(key)) {
            this.egitPrefs.put(key, value);
        }
    }
}

