/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.metadata.model;

import java.io.Serializable;
import java.util.Set;
import org.springframework.ide.eclipse.beans.core.metadata.model.IMethodMetadata;
import org.springframework.ide.eclipse.core.java.annotation.AnnotationMemberValuePair;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.util.ObjectUtils;

public abstract class AbstractMethodAnnotationMetadata
implements IMethodMetadata,
Serializable {
    private static final long serialVersionUID = -825792015551282251L;
    private String key;
    private String handle;
    private Object value;
    private IModelSourceLocation location;

    public AbstractMethodAnnotationMetadata(String key, String handle, Object value, IModelSourceLocation location) {
        this.handle = handle;
        this.value = value;
        this.location = location;
        this.key = key;
    }

    public String getMethodHandle() {
        return this.handle;
    }

    @Override
    public String getHandleIdentifier() {
        return this.handle;
    }

    @Override
    public IModelSourceLocation getElementSourceLocation() {
        return this.location;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getValueAsText() {
        if (this.value instanceof Set) {
            StringBuilder buf = new StringBuilder();
            for (AnnotationMemberValuePair pair : (Set)this.value) {
                if (pair.getName() != null) {
                    buf.append(pair.getName());
                    buf.append(" = ");
                }
                buf.append(pair.getValue());
                buf.append(", ");
            }
            if (buf.length() > 0) {
                return String.valueOf(buf.substring(0, buf.length() - 2)) + " - ";
            }
            return "";
        }
        return "";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbstractMethodAnnotationMetadata)) {
            return false;
        }
        AbstractMethodAnnotationMetadata that = (AbstractMethodAnnotationMetadata)other;
        if (!ObjectUtils.nullSafeEquals((Object)this.value, (Object)that.value)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.handle, (Object)that.handle)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.key, (Object)that.key)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.location, (Object)that.location);
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object)this.value);
        hashCode += ObjectUtils.nullSafeHashCode((Object)this.handle);
        hashCode += ObjectUtils.nullSafeHashCode((Object)this.key);
        return 9 * (hashCode += ObjectUtils.nullSafeHashCode((Object)this.location));
    }
}

