/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.metadata.internal.model;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeanProperty;
import org.springframework.ide.eclipse.beans.core.internal.model.SerializableRuntimeBeanReference;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.core.model.IBeanReference;

public class BeanPropertyDataHolder
implements Serializable {
    private static final long serialVersionUID = 3826359277035252154L;
    private long lastModified = -1L;
    private Set<PropertyValue> beanProperties;
    private String elemenetId;

    public Set<IBeanProperty> getBeanProperties() {
        IBean bean = (IBean)BeansCorePlugin.getModel().getElement(this.getElemenetId());
        LinkedHashSet<IBeanProperty> properties = new LinkedHashSet<IBeanProperty>();
        for (PropertyValue property : this.beanProperties) {
            RuntimeBeanReference rbr = new RuntimeBeanReference(((SerializableRuntimeBeanReference)property.getValue()).getBeanName());
            rbr.setSource(((SerializableRuntimeBeanReference)property.getValue()).getSource());
            PropertyValue pv = new PropertyValue(property.getName(), (Object)rbr);
            pv.setSource(((SerializableRuntimeBeanReference)property.getValue()).getSource());
            BeanProperty beanProperty = new BeanProperty(bean, pv);
            properties.add((IBeanProperty)beanProperty);
        }
        return properties;
    }

    public String getElemenetId() {
        return this.elemenetId;
    }

    public void setBeanProperties(Set<IBeanProperty> properties) {
        this.beanProperties = new LinkedHashSet<PropertyValue>();
        for (IBeanProperty property : properties) {
            if (!(property.getValue() instanceof IBeanReference)) continue;
            IBeanReference reference = (IBeanReference)property.getValue();
            SerializableRuntimeBeanReference rbr = new SerializableRuntimeBeanReference();
            rbr.setBeanName(reference.getBeanName());
            rbr.setToParent(false);
            rbr.setSource((Object)property.getElementSourceLocation());
            this.beanProperties.add(new PropertyValue(property.getElementName(), (Object)rbr));
        }
    }

    public void setElemenetId(String elemenetId) {
        this.elemenetId = elemenetId;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }
}

