/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.graph.popup.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.commands.GetLogsCommand;
import org.tigris.subversion.subclipse.core.history.AliasManager;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.resources.RemoteFile;
import org.tigris.subversion.subclipse.graph.cache.Node;
import org.tigris.subversion.subclipse.graph.editors.RevisionGraphEditor;
import org.tigris.subversion.subclipse.graph.editors.RevisionGraphEditorInput;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.dialogs.ShowRevisionsDialog;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RevisionDetailsAction
extends Action {
    private Node node;
    private RevisionGraphEditor editor;
    private ISVNRemoteResource remoteResource;
    private ILogEntry logEntry;
    private boolean includeTags;

    public RevisionDetailsAction(Node node, RevisionGraphEditor editor) {
        this.node = node;
        this.editor = editor;
        this.setText("Revision info...");
    }

    public void run() {
        this.remoteResource = null;
        this.logEntry = null;
        this.includeTags = SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_show_tags_in_remote");
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    RevisionGraphEditorInput input = (RevisionGraphEditorInput)RevisionDetailsAction.this.editor.getEditorInput();
                    ISVNInfo info = input.getInfo();
                    ISVNRepositoryLocation repository = SVNProviderPlugin.getPlugin().getRepository(info.getRepository().toString());
                    RevisionDetailsAction.this.remoteResource = (ISVNRemoteResource)new RemoteFile(repository, new SVNUrl(String.valueOf(repository.getLocation()) + RevisionDetailsAction.this.node.getPath()), (SVNRevision)new SVNRevision.Number(RevisionDetailsAction.this.node.getRevision()));
                    AliasManager tagManager = null;
                    if (RevisionDetailsAction.this.includeTags) {
                        tagManager = new AliasManager(RevisionDetailsAction.this.remoteResource.getUrl());
                    }
                    SVNRevision.Number pegRevision = new SVNRevision.Number(RevisionDetailsAction.this.node.getRevision());
                    SVNRevision.Number revisionStart = new SVNRevision.Number(RevisionDetailsAction.this.node.getRevision());
                    SVNRevision.Number revisionEnd = new SVNRevision.Number(RevisionDetailsAction.this.node.getRevision());
                    GetLogsCommand logCmd = new GetLogsCommand(RevisionDetailsAction.this.remoteResource, (SVNRevision)pegRevision, (SVNRevision)revisionStart, (SVNRevision)revisionEnd, false, 0L, tagManager, true);
                    logCmd.run(null);
                    ILogEntry[] logEntries = logCmd.getLogEntries();
                    if (logEntries != null && logEntries.length > 0) {
                        RevisionDetailsAction.this.logEntry = logEntries[0];
                    }
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Revision Info", (String)e.getMessage());
                }
            }
        });
        if (this.logEntry != null) {
            ShowRevisionsDialog dialog = new ShowRevisionsDialog(Display.getDefault().getActiveShell(), this.logEntry, this.remoteResource, this.includeTags, null);
            dialog.setTitle("Revision Info");
            dialog.setSelectFirst(true);
            dialog.open();
        }
    }
}

