/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.graph.editors;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.svnclientadapter.ISVNInfo;

public class RevisionGraphEditorInput
implements IEditorInput {
    private IResource resource;
    private ISVNRemoteResource remoteResource;
    private ISVNInfo info;

    public RevisionGraphEditorInput(IResource resource) {
        this.resource = resource;
    }

    public RevisionGraphEditorInput(ISVNRemoteResource remoteResource) {
        this.remoteResource = remoteResource;
    }

    public IResource getResource() {
        return this.resource;
    }

    public ISVNRemoteResource getRemoteResource() {
        return this.remoteResource;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.getName());
    }

    public String getName() {
        if (this.resource == null) {
            return this.remoteResource.getName();
        }
        return this.resource.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.getName();
    }

    public Object getAdapter(Class adapter) {
        if (this.resource == null) {
            if (adapter == ISVNRemoteResource.class) {
                return this.remoteResource;
            }
            return this.remoteResource.getAdapter(adapter);
        }
        if (adapter == IResource.class) {
            return this.resource;
        }
        return this.resource.getAdapter(adapter);
    }

    public ISVNInfo getInfo() {
        return this.info;
    }

    public void setInfo(ISVNInfo info) {
        this.info = info;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RevisionGraphEditorInput) {
            RevisionGraphEditorInput compareTo = (RevisionGraphEditorInput)obj;
            if (this.resource != null && compareTo.getResource() != null) {
                return this.resource.equals((Object)compareTo.getResource());
            }
            if (this.remoteResource != null && compareTo.getRemoteResource() != null) {
                return this.remoteResource.equals((Object)compareTo.getRemoteResource());
            }
        }
        return super.equals(obj);
    }
}

